package smartag

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeSAGDeviceInfo invokes the smartag.DescribeSAGDeviceInfo API synchronously
func (client *Client) DescribeSAGDeviceInfo(request *DescribeSAGDeviceInfoRequest) (response *DescribeSAGDeviceInfoResponse, err error) {
	response = CreateDescribeSAGDeviceInfoResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeSAGDeviceInfoWithChan invokes the smartag.DescribeSAGDeviceInfo API asynchronously
func (client *Client) DescribeSAGDeviceInfoWithChan(request *DescribeSAGDeviceInfoRequest) (<-chan *DescribeSAGDeviceInfoResponse, <-chan error) {
	responseChan := make(chan *DescribeSAGDeviceInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeSAGDeviceInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeSAGDeviceInfoWithCallback invokes the smartag.DescribeSAGDeviceInfo API asynchronously
func (client *Client) DescribeSAGDeviceInfoWithCallback(request *DescribeSAGDeviceInfoRequest, callback func(response *DescribeSAGDeviceInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeSAGDeviceInfoResponse
		var err error
		defer close(result)
		response, err = client.DescribeSAGDeviceInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeSAGDeviceInfoRequest is the request struct for api DescribeSAGDeviceInfo
type DescribeSAGDeviceInfoRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	SmartAGId            string           `position:"Query" name:"SmartAGId"`
	SmartAGSn            string           `position:"Query" name:"SmartAGSn"`
}

// DescribeSAGDeviceInfoResponse is the response struct for api DescribeSAGDeviceInfo
type DescribeSAGDeviceInfoResponse struct {
	*responses.BaseResponse
	ServiceIP                   string `json:"ServiceIP" xml:"ServiceIP"`
	ControllerState             string `json:"ControllerState" xml:"ControllerState"`
	RequestId                   string `json:"RequestId" xml:"RequestId"`
	SynStatus                   string `json:"SynStatus" xml:"SynStatus"`
	SmartAGType                 string `json:"SmartAGType" xml:"SmartAGType"`
	Version                     string `json:"Version" xml:"Version"`
	VpnState                    string `json:"VpnState" xml:"VpnState"`
	StartupTime                 string `json:"StartupTime" xml:"StartupTime"`
	LastConnectedControllerTime string `json:"LastConnectedControllerTime" xml:"LastConnectedControllerTime"`
	ResettableStatus            string `json:"ResettableStatus" xml:"ResettableStatus"`
}

// CreateDescribeSAGDeviceInfoRequest creates a request to invoke DescribeSAGDeviceInfo API
func CreateDescribeSAGDeviceInfoRequest() (request *DescribeSAGDeviceInfoRequest) {
	request = &DescribeSAGDeviceInfoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Smartag", "2018-03-13", "DescribeSAGDeviceInfo", "smartag", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeSAGDeviceInfoResponse creates a response to parse from DescribeSAGDeviceInfo response
func CreateDescribeSAGDeviceInfoResponse() (response *DescribeSAGDeviceInfoResponse) {
	response = &DescribeSAGDeviceInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
