package selectdb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyDBInstanceAttribute invokes the selectdb.ModifyDBInstanceAttribute API synchronously
func (client *Client) ModifyDBInstanceAttribute(request *ModifyDBInstanceAttributeRequest) (response *ModifyDBInstanceAttributeResponse, err error) {
	response = CreateModifyDBInstanceAttributeResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyDBInstanceAttributeWithChan invokes the selectdb.ModifyDBInstanceAttribute API asynchronously
func (client *Client) ModifyDBInstanceAttributeWithChan(request *ModifyDBInstanceAttributeRequest) (<-chan *ModifyDBInstanceAttributeResponse, <-chan error) {
	responseChan := make(chan *ModifyDBInstanceAttributeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyDBInstanceAttribute(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyDBInstanceAttributeWithCallback invokes the selectdb.ModifyDBInstanceAttribute API asynchronously
func (client *Client) ModifyDBInstanceAttributeWithCallback(request *ModifyDBInstanceAttributeRequest, callback func(response *ModifyDBInstanceAttributeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyDBInstanceAttributeResponse
		var err error
		defer close(result)
		response, err = client.ModifyDBInstanceAttribute(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyDBInstanceAttributeRequest is the request struct for api ModifyDBInstanceAttribute
type ModifyDBInstanceAttributeRequest struct {
	*requests.RpcRequest
	ResourceOwnerId       requests.Integer `position:"Query" name:"ResourceOwnerId"`
	DBInstanceId          string           `position:"Query" name:"DBInstanceId"`
	Value                 string           `position:"Query" name:"Value"`
	InstanceAttributeType string           `position:"Query" name:"InstanceAttributeType"`
}

// ModifyDBInstanceAttributeResponse is the response struct for api ModifyDBInstanceAttribute
type ModifyDBInstanceAttributeResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyDBInstanceAttributeRequest creates a request to invoke ModifyDBInstanceAttribute API
func CreateModifyDBInstanceAttributeRequest() (request *ModifyDBInstanceAttributeRequest) {
	request = &ModifyDBInstanceAttributeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("selectdb", "2023-05-22", "ModifyDBInstanceAttribute", "", "")
	request.Method = requests.POST
	return
}

// CreateModifyDBInstanceAttributeResponse creates a response to parse from ModifyDBInstanceAttribute response
func CreateModifyDBInstanceAttributeResponse() (response *ModifyDBInstanceAttributeResponse) {
	response = &ModifyDBInstanceAttributeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
