package sddp

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDocTypes invokes the sddp.DescribeDocTypes API synchronously
func (client *Client) DescribeDocTypes(request *DescribeDocTypesRequest) (response *DescribeDocTypesResponse, err error) {
	response = CreateDescribeDocTypesResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDocTypesWithChan invokes the sddp.DescribeDocTypes API asynchronously
func (client *Client) DescribeDocTypesWithChan(request *DescribeDocTypesRequest) (<-chan *DescribeDocTypesResponse, <-chan error) {
	responseChan := make(chan *DescribeDocTypesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDocTypes(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDocTypesWithCallback invokes the sddp.DescribeDocTypes API asynchronously
func (client *Client) DescribeDocTypesWithCallback(request *DescribeDocTypesRequest, callback func(response *DescribeDocTypesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDocTypesResponse
		var err error
		defer close(result)
		response, err = client.DescribeDocTypes(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDocTypesRequest is the request struct for api DescribeDocTypes
type DescribeDocTypesRequest struct {
	*requests.RpcRequest
	FeatureType requests.Integer `position:"Query" name:"FeatureType"`
	SourceIp    string           `position:"Query" name:"SourceIp"`
	Lang        string           `position:"Query" name:"Lang"`
}

// DescribeDocTypesResponse is the response struct for api DescribeDocTypes
type DescribeDocTypesResponse struct {
	*responses.BaseResponse
	RequestId   string    `json:"RequestId" xml:"RequestId"`
	DocTypeList []DocType `json:"DocTypeList" xml:"DocTypeList"`
}

// CreateDescribeDocTypesRequest creates a request to invoke DescribeDocTypes API
func CreateDescribeDocTypesRequest() (request *DescribeDocTypesRequest) {
	request = &DescribeDocTypesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Sddp", "2019-01-03", "DescribeDocTypes", "sddp", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeDocTypesResponse creates a response to parse from DescribeDocTypes response
func CreateDescribeDocTypesResponse() (response *DescribeDocTypesResponse) {
	response = &DescribeDocTypesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
