package sas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetFileDetectResult invokes the sas.GetFileDetectResult API synchronously
func (client *Client) GetFileDetectResult(request *GetFileDetectResultRequest) (response *GetFileDetectResultResponse, err error) {
	response = CreateGetFileDetectResultResponse()
	err = client.DoAction(request, response)
	return
}

// GetFileDetectResultWithChan invokes the sas.GetFileDetectResult API asynchronously
func (client *Client) GetFileDetectResultWithChan(request *GetFileDetectResultRequest) (<-chan *GetFileDetectResultResponse, <-chan error) {
	responseChan := make(chan *GetFileDetectResultResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetFileDetectResult(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetFileDetectResultWithCallback invokes the sas.GetFileDetectResult API asynchronously
func (client *Client) GetFileDetectResultWithCallback(request *GetFileDetectResultRequest, callback func(response *GetFileDetectResultResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetFileDetectResultResponse
		var err error
		defer close(result)
		response, err = client.GetFileDetectResult(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetFileDetectResultRequest is the request struct for api GetFileDetectResult
type GetFileDetectResultRequest struct {
	*requests.RpcRequest
	HashKeyList *[]string        `position:"Query" name:"HashKeyList"  type:"Repeated"`
	Type        requests.Integer `position:"Query" name:"Type"`
	SourceIp    string           `position:"Query" name:"SourceIp"`
}

// GetFileDetectResultResponse is the response struct for api GetFileDetectResult
type GetFileDetectResultResponse struct {
	*responses.BaseResponse
	RequestId  string   `json:"RequestId" xml:"RequestId"`
	ResultList []Result `json:"ResultList" xml:"ResultList"`
}

// CreateGetFileDetectResultRequest creates a request to invoke GetFileDetectResult API
func CreateGetFileDetectResultRequest() (request *GetFileDetectResultRequest) {
	request = &GetFileDetectResultRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Sas", "2018-12-03", "GetFileDetectResult", "sas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetFileDetectResultResponse creates a response to parse from GetFileDetectResult response
func CreateGetFileDetectResultResponse() (response *GetFileDetectResultResponse) {
	response = &GetFileDetectResultResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
