package safe

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SafeScopeData invokes the safe.SafeScopeData API synchronously
func (client *Client) SafeScopeData(request *SafeScopeDataRequest) (response *SafeScopeDataResponse, err error) {
	response = CreateSafeScopeDataResponse()
	err = client.DoAction(request, response)
	return
}

// SafeScopeDataWithChan invokes the safe.SafeScopeData API asynchronously
func (client *Client) SafeScopeDataWithChan(request *SafeScopeDataRequest) (<-chan *SafeScopeDataResponse, <-chan error) {
	responseChan := make(chan *SafeScopeDataResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SafeScopeData(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SafeScopeDataWithCallback invokes the safe.SafeScopeData API asynchronously
func (client *Client) SafeScopeDataWithCallback(request *SafeScopeDataRequest, callback func(response *SafeScopeDataResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SafeScopeDataResponse
		var err error
		defer close(result)
		response, err = client.SafeScopeData(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SafeScopeDataRequest is the request struct for api SafeScopeData
type SafeScopeDataRequest struct {
	*requests.RpcRequest
	AuthKey        string           `position:"Body" name:"AuthKey"`
	Item           string           `position:"Body" name:"Item"`
	ProductCode    string           `position:"Body" name:"ProductCode"`
	ProductId      requests.Integer `position:"Body" name:"ProductId"`
	CodeList       string           `position:"Body" name:"CodeList"`
	ParentCode     string           `position:"Body" name:"ParentCode"`
	OrderDirection string           `position:"Body" name:"OrderDirection"`
	OrderBy        string           `position:"Body" name:"OrderBy"`
	AuthSign       string           `position:"Body" name:"AuthSign"`
	RegionNameEn   string           `position:"Body" name:"RegionNameEn"`
	GroupBy        string           `position:"Body" name:"GroupBy"`
	Type           requests.Integer `position:"Body" name:"Type"`
	ParentId       requests.Integer `position:"Body" name:"ParentId"`
	Uid            string           `position:"Body" name:"Uid"`
	ReqTimestamp   requests.Integer `position:"Body" name:"ReqTimestamp"`
	NeedTotalCount requests.Boolean `position:"Body" name:"NeedTotalCount"`
	Limit          requests.Integer `position:"Body" name:"Limit"`
	IdList         string           `position:"Body" name:"IdList"`
	Page           requests.Integer `position:"Body" name:"Page"`
	Factor         string           `position:"Body" name:"Factor"`
	Category       string           `position:"Body" name:"Category"`
	SearchValue    string           `position:"Body" name:"SearchValue"`
}

// SafeScopeDataResponse is the response struct for api SafeScopeData
type SafeScopeDataResponse struct {
	*responses.BaseResponse
	Success   bool   `json:"Success" xml:"Success"`
	Code      int    `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateSafeScopeDataRequest creates a request to invoke SafeScopeData API
func CreateSafeScopeDataRequest() (request *SafeScopeDataRequest) {
	request = &SafeScopeDataRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Safe", "2022-01-17", "SafeScopeData", "", "")
	request.Method = requests.POST
	return
}

// CreateSafeScopeDataResponse creates a response to parse from SafeScopeData response
func CreateSafeScopeDataResponse() (response *SafeScopeDataResponse) {
	response = &SafeScopeDataResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
