package sae

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateApplicationDescription invokes the sae.UpdateApplicationDescription API synchronously
func (client *Client) UpdateApplicationDescription(request *UpdateApplicationDescriptionRequest) (response *UpdateApplicationDescriptionResponse, err error) {
	response = CreateUpdateApplicationDescriptionResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateApplicationDescriptionWithChan invokes the sae.UpdateApplicationDescription API asynchronously
func (client *Client) UpdateApplicationDescriptionWithChan(request *UpdateApplicationDescriptionRequest) (<-chan *UpdateApplicationDescriptionResponse, <-chan error) {
	responseChan := make(chan *UpdateApplicationDescriptionResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateApplicationDescription(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateApplicationDescriptionWithCallback invokes the sae.UpdateApplicationDescription API asynchronously
func (client *Client) UpdateApplicationDescriptionWithCallback(request *UpdateApplicationDescriptionRequest, callback func(response *UpdateApplicationDescriptionResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateApplicationDescriptionResponse
		var err error
		defer close(result)
		response, err = client.UpdateApplicationDescription(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateApplicationDescriptionRequest is the request struct for api UpdateApplicationDescription
type UpdateApplicationDescriptionRequest struct {
	*requests.RoaRequest
	AppDescription string `position:"Query" name:"AppDescription"`
	AppId          string `position:"Query" name:"AppId"`
}

// UpdateApplicationDescriptionResponse is the response struct for api UpdateApplicationDescription
type UpdateApplicationDescriptionResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Message   string `json:"Message" xml:"Message"`
	TraceId   string `json:"TraceId" xml:"TraceId"`
	ErrorCode string `json:"ErrorCode" xml:"ErrorCode"`
	Code      string `json:"Code" xml:"Code"`
	Success   bool   `json:"Success" xml:"Success"`
}

// CreateUpdateApplicationDescriptionRequest creates a request to invoke UpdateApplicationDescription API
func CreateUpdateApplicationDescriptionRequest() (request *UpdateApplicationDescriptionRequest) {
	request = &UpdateApplicationDescriptionRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("sae", "2019-05-06", "UpdateApplicationDescription", "/pop/v1/sam/app/updateAppDescription", "serverless", "openAPI")
	request.Method = requests.PUT
	return
}

// CreateUpdateApplicationDescriptionResponse creates a response to parse from UpdateApplicationDescription response
func CreateUpdateApplicationDescriptionResponse() (response *UpdateApplicationDescriptionResponse) {
	response = &UpdateApplicationDescriptionResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
