package retailadvqa_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SearchAudience invokes the retailadvqa_public.SearchAudience API synchronously
func (client *Client) SearchAudience(request *SearchAudienceRequest) (response *SearchAudienceResponse, err error) {
	response = CreateSearchAudienceResponse()
	err = client.DoAction(request, response)
	return
}

// SearchAudienceWithChan invokes the retailadvqa_public.SearchAudience API asynchronously
func (client *Client) SearchAudienceWithChan(request *SearchAudienceRequest) (<-chan *SearchAudienceResponse, <-chan error) {
	responseChan := make(chan *SearchAudienceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SearchAudience(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SearchAudienceWithCallback invokes the retailadvqa_public.SearchAudience API asynchronously
func (client *Client) SearchAudienceWithCallback(request *SearchAudienceRequest, callback func(response *SearchAudienceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SearchAudienceResponse
		var err error
		defer close(result)
		response, err = client.SearchAudience(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SearchAudienceRequest is the request struct for api SearchAudience
type SearchAudienceRequest struct {
	*requests.RpcRequest
	AccessId    string `position:"Query" name:"AccessId"`
	AudienceId  string `position:"Query" name:"AudienceId"`
	WorkspaceId string `position:"Query" name:"WorkspaceId"`
}

// SearchAudienceResponse is the response struct for api SearchAudience
type SearchAudienceResponse struct {
	*responses.BaseResponse
	RequestId string               `json:"RequestId" xml:"RequestId"`
	ErrorDesc string               `json:"ErrorDesc" xml:"ErrorDesc"`
	TraceId   string               `json:"TraceId" xml:"TraceId"`
	ErrorCode string               `json:"ErrorCode" xml:"ErrorCode"`
	Success   bool                 `json:"Success" xml:"Success"`
	Data      DataInSearchAudience `json:"Data" xml:"Data"`
}

// CreateSearchAudienceRequest creates a request to invoke SearchAudience API
func CreateSearchAudienceRequest() (request *SearchAudienceRequest) {
	request = &SearchAudienceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("retailadvqa-public", "2020-05-15", "SearchAudience", "", "")
	request.Method = requests.POST
	return
}

// CreateSearchAudienceResponse creates a response to parse from SearchAudience response
func CreateSearchAudienceResponse() (response *SearchAudienceResponse) {
	response = &SearchAudienceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
