package retailadvqa_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateDefaultEventSource invokes the retailadvqa_public.CreateDefaultEventSource API synchronously
func (client *Client) CreateDefaultEventSource(request *CreateDefaultEventSourceRequest) (response *CreateDefaultEventSourceResponse, err error) {
	response = CreateCreateDefaultEventSourceResponse()
	err = client.DoAction(request, response)
	return
}

// CreateDefaultEventSourceWithChan invokes the retailadvqa_public.CreateDefaultEventSource API asynchronously
func (client *Client) CreateDefaultEventSourceWithChan(request *CreateDefaultEventSourceRequest) (<-chan *CreateDefaultEventSourceResponse, <-chan error) {
	responseChan := make(chan *CreateDefaultEventSourceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateDefaultEventSource(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateDefaultEventSourceWithCallback invokes the retailadvqa_public.CreateDefaultEventSource API asynchronously
func (client *Client) CreateDefaultEventSourceWithCallback(request *CreateDefaultEventSourceRequest, callback func(response *CreateDefaultEventSourceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateDefaultEventSourceResponse
		var err error
		defer close(result)
		response, err = client.CreateDefaultEventSource(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateDefaultEventSourceRequest is the request struct for api CreateDefaultEventSource
type CreateDefaultEventSourceRequest struct {
	*requests.RpcRequest
	AccessId            string `position:"Query" name:"AccessId"`
	EventSourceModelStr string `position:"Body" name:"EventSourceModelStr"`
	TenantId            string `position:"Query" name:"TenantId"`
	WorkspaceId         string `position:"Query" name:"WorkspaceId"`
}

// CreateDefaultEventSourceResponse is the response struct for api CreateDefaultEventSource
type CreateDefaultEventSourceResponse struct {
	*responses.BaseResponse
	ErrorDesc string `json:"ErrorDesc" xml:"ErrorDesc"`
	TraceId   string `json:"TraceId" xml:"TraceId"`
	ErrorCode string `json:"ErrorCode" xml:"ErrorCode"`
	Success   bool   `json:"Success" xml:"Success"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateCreateDefaultEventSourceRequest creates a request to invoke CreateDefaultEventSource API
func CreateCreateDefaultEventSourceRequest() (request *CreateDefaultEventSourceRequest) {
	request = &CreateDefaultEventSourceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("retailadvqa-public", "2020-05-15", "CreateDefaultEventSource", "", "")
	request.Method = requests.POST
	return
}

// CreateCreateDefaultEventSourceResponse creates a response to parse from CreateDefaultEventSource response
func CreateCreateDefaultEventSourceResponse() (response *CreateDefaultEventSourceResponse) {
	response = &CreateDefaultEventSourceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
