package retailadvqa_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ActivityInfoQuery invokes the retailadvqa_public.ActivityInfoQuery API synchronously
func (client *Client) ActivityInfoQuery(request *ActivityInfoQueryRequest) (response *ActivityInfoQueryResponse, err error) {
	response = CreateActivityInfoQueryResponse()
	err = client.DoAction(request, response)
	return
}

// ActivityInfoQueryWithChan invokes the retailadvqa_public.ActivityInfoQuery API asynchronously
func (client *Client) ActivityInfoQueryWithChan(request *ActivityInfoQueryRequest) (<-chan *ActivityInfoQueryResponse, <-chan error) {
	responseChan := make(chan *ActivityInfoQueryResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ActivityInfoQuery(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ActivityInfoQueryWithCallback invokes the retailadvqa_public.ActivityInfoQuery API asynchronously
func (client *Client) ActivityInfoQueryWithCallback(request *ActivityInfoQueryRequest, callback func(response *ActivityInfoQueryResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ActivityInfoQueryResponse
		var err error
		defer close(result)
		response, err = client.ActivityInfoQuery(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ActivityInfoQueryRequest is the request struct for api ActivityInfoQuery
type ActivityInfoQueryRequest struct {
	*requests.RpcRequest
	AccessId              string           `position:"Query" name:"AccessId"`
	PrivateKey            string           `position:"Query" name:"PrivateKey"`
	IsMainActivity        requests.Boolean `position:"Query" name:"IsMainActivity"`
	IsIncludeMainActivity requests.Boolean `position:"Query" name:"IsIncludeMainActivity"`
	PageSize              requests.Integer `position:"Query" name:"PageSize"`
	PageNum               requests.Integer `position:"Query" name:"PageNum"`
	WorkspaceId           string           `position:"Query" name:"WorkspaceId"`
}

// ActivityInfoQueryResponse is the response struct for api ActivityInfoQuery
type ActivityInfoQueryResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	ErrorDesc string `json:"ErrorDesc" xml:"ErrorDesc"`
	TraceId   string `json:"TraceId" xml:"TraceId"`
	ErrorCode string `json:"ErrorCode" xml:"ErrorCode"`
	Success   bool   `json:"Success" xml:"Success"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateActivityInfoQueryRequest creates a request to invoke ActivityInfoQuery API
func CreateActivityInfoQueryRequest() (request *ActivityInfoQueryRequest) {
	request = &ActivityInfoQueryRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("retailadvqa-public", "2020-05-15", "ActivityInfoQuery", "", "")
	request.Method = requests.POST
	return
}

// CreateActivityInfoQueryResponse creates a response to parse from ActivityInfoQuery response
func CreateActivityInfoQueryResponse() (response *ActivityInfoQueryResponse) {
	response = &ActivityInfoQueryResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
