package resourcecenter

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateFilter invokes the resourcecenter.UpdateFilter API synchronously
func (client *Client) UpdateFilter(request *UpdateFilterRequest) (response *UpdateFilterResponse, err error) {
	response = CreateUpdateFilterResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateFilterWithChan invokes the resourcecenter.UpdateFilter API asynchronously
func (client *Client) UpdateFilterWithChan(request *UpdateFilterRequest) (<-chan *UpdateFilterResponse, <-chan error) {
	responseChan := make(chan *UpdateFilterResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateFilter(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateFilterWithCallback invokes the resourcecenter.UpdateFilter API asynchronously
func (client *Client) UpdateFilterWithCallback(request *UpdateFilterRequest, callback func(response *UpdateFilterResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateFilterResponse
		var err error
		defer close(result)
		response, err = client.UpdateFilter(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateFilterRequest is the request struct for api UpdateFilter
type UpdateFilterRequest struct {
	*requests.RpcRequest
	FilterName          string `position:"Query" name:"FilterName"`
	FilterConfiguration string `position:"Query" name:"FilterConfiguration"`
}

// UpdateFilterResponse is the response struct for api UpdateFilter
type UpdateFilterResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateUpdateFilterRequest creates a request to invoke UpdateFilter API
func CreateUpdateFilterRequest() (request *UpdateFilterRequest) {
	request = &UpdateFilterRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ResourceCenter", "2022-12-01", "UpdateFilter", "", "")
	request.Method = requests.POST
	return
}

// CreateUpdateFilterResponse creates a response to parse from UpdateFilter response
func CreateUpdateFilterResponse() (response *UpdateFilterResponse) {
	response = &UpdateFilterResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
