package rds

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteDBInstanceSecurityGroupRule invokes the rds.DeleteDBInstanceSecurityGroupRule API synchronously
func (client *Client) DeleteDBInstanceSecurityGroupRule(request *DeleteDBInstanceSecurityGroupRuleRequest) (response *DeleteDBInstanceSecurityGroupRuleResponse, err error) {
	response = CreateDeleteDBInstanceSecurityGroupRuleResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteDBInstanceSecurityGroupRuleWithChan invokes the rds.DeleteDBInstanceSecurityGroupRule API asynchronously
func (client *Client) DeleteDBInstanceSecurityGroupRuleWithChan(request *DeleteDBInstanceSecurityGroupRuleRequest) (<-chan *DeleteDBInstanceSecurityGroupRuleResponse, <-chan error) {
	responseChan := make(chan *DeleteDBInstanceSecurityGroupRuleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteDBInstanceSecurityGroupRule(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteDBInstanceSecurityGroupRuleWithCallback invokes the rds.DeleteDBInstanceSecurityGroupRule API asynchronously
func (client *Client) DeleteDBInstanceSecurityGroupRuleWithCallback(request *DeleteDBInstanceSecurityGroupRuleRequest, callback func(response *DeleteDBInstanceSecurityGroupRuleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteDBInstanceSecurityGroupRuleResponse
		var err error
		defer close(result)
		response, err = client.DeleteDBInstanceSecurityGroupRule(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteDBInstanceSecurityGroupRuleRequest is the request struct for api DeleteDBInstanceSecurityGroupRule
type DeleteDBInstanceSecurityGroupRuleRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ClientToken          string           `position:"Query" name:"ClientToken"`
	SecurityGroupRuleIds string           `position:"Query" name:"SecurityGroupRuleIds"`
	ResourceGroupId      string           `position:"Query" name:"ResourceGroupId"`
	DBInstanceId         string           `position:"Query" name:"DBInstanceId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              string           `position:"Query" name:"OwnerId"`
}

// DeleteDBInstanceSecurityGroupRuleResponse is the response struct for api DeleteDBInstanceSecurityGroupRule
type DeleteDBInstanceSecurityGroupRuleResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Message   string `json:"Message" xml:"Message"`
	Code      string `json:"Code" xml:"Code"`
}

// CreateDeleteDBInstanceSecurityGroupRuleRequest creates a request to invoke DeleteDBInstanceSecurityGroupRule API
func CreateDeleteDBInstanceSecurityGroupRuleRequest() (request *DeleteDBInstanceSecurityGroupRuleRequest) {
	request = &DeleteDBInstanceSecurityGroupRuleRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Rds", "2014-08-15", "DeleteDBInstanceSecurityGroupRule", "rds", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteDBInstanceSecurityGroupRuleResponse creates a response to parse from DeleteDBInstanceSecurityGroupRule response
func CreateDeleteDBInstanceSecurityGroupRuleResponse() (response *DeleteDBInstanceSecurityGroupRuleResponse) {
	response = &DeleteDBInstanceSecurityGroupRuleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
