package r_kvstore

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyDBInstanceAutoUpgrade invokes the r_kvstore.ModifyDBInstanceAutoUpgrade API synchronously
func (client *Client) ModifyDBInstanceAutoUpgrade(request *ModifyDBInstanceAutoUpgradeRequest) (response *ModifyDBInstanceAutoUpgradeResponse, err error) {
	response = CreateModifyDBInstanceAutoUpgradeResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyDBInstanceAutoUpgradeWithChan invokes the r_kvstore.ModifyDBInstanceAutoUpgrade API asynchronously
func (client *Client) ModifyDBInstanceAutoUpgradeWithChan(request *ModifyDBInstanceAutoUpgradeRequest) (<-chan *ModifyDBInstanceAutoUpgradeResponse, <-chan error) {
	responseChan := make(chan *ModifyDBInstanceAutoUpgradeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyDBInstanceAutoUpgrade(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyDBInstanceAutoUpgradeWithCallback invokes the r_kvstore.ModifyDBInstanceAutoUpgrade API asynchronously
func (client *Client) ModifyDBInstanceAutoUpgradeWithCallback(request *ModifyDBInstanceAutoUpgradeRequest, callback func(response *ModifyDBInstanceAutoUpgradeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyDBInstanceAutoUpgradeResponse
		var err error
		defer close(result)
		response, err = client.ModifyDBInstanceAutoUpgrade(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyDBInstanceAutoUpgradeRequest is the request struct for api ModifyDBInstanceAutoUpgrade
type ModifyDBInstanceAutoUpgradeRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	SecurityToken        string           `position:"Query" name:"SecurityToken"`
	DBInstanceId         string           `position:"Query" name:"DBInstanceId"`
	Value                string           `position:"Query" name:"Value"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// ModifyDBInstanceAutoUpgradeResponse is the response struct for api ModifyDBInstanceAutoUpgrade
type ModifyDBInstanceAutoUpgradeResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyDBInstanceAutoUpgradeRequest creates a request to invoke ModifyDBInstanceAutoUpgrade API
func CreateModifyDBInstanceAutoUpgradeRequest() (request *ModifyDBInstanceAutoUpgradeRequest) {
	request = &ModifyDBInstanceAutoUpgradeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("R-kvstore", "2015-01-01", "ModifyDBInstanceAutoUpgrade", "redisa", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifyDBInstanceAutoUpgradeResponse creates a response to parse from ModifyDBInstanceAutoUpgrade response
func CreateModifyDBInstanceAutoUpgradeResponse() (response *ModifyDBInstanceAutoUpgradeResponse) {
	response = &ModifyDBInstanceAutoUpgradeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
