package quickbi_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryData invokes the quickbi_public.QueryData API synchronously
func (client *Client) QueryData(request *QueryDataRequest) (response *QueryDataResponse, err error) {
	response = CreateQueryDataResponse()
	err = client.DoAction(request, response)
	return
}

// QueryDataWithChan invokes the quickbi_public.QueryData API asynchronously
func (client *Client) QueryDataWithChan(request *QueryDataRequest) (<-chan *QueryDataResponse, <-chan error) {
	responseChan := make(chan *QueryDataResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryData(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryDataWithCallback invokes the quickbi_public.QueryData API asynchronously
func (client *Client) QueryDataWithCallback(request *QueryDataRequest, callback func(response *QueryDataResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryDataResponse
		var err error
		defer close(result)
		response, err = client.QueryData(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryDataRequest is the request struct for api QueryData
type QueryDataRequest struct {
	*requests.RpcRequest
	AccessPoint  string `position:"Query" name:"AccessPoint"`
	UserId       string `position:"Query" name:"UserId"`
	SignType     string `position:"Query" name:"SignType"`
	ReturnFields string `position:"Query" name:"ReturnFields"`
	Conditions   string `position:"Query" name:"Conditions"`
	ApiId        string `position:"Query" name:"ApiId"`
}

// QueryDataResponse is the response struct for api QueryData
type QueryDataResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Result    Result `json:"Result" xml:"Result"`
}

// CreateQueryDataRequest creates a request to invoke QueryData API
func CreateQueryDataRequest() (request *QueryDataRequest) {
	request = &QueryDataRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("quickbi-public", "2022-01-01", "QueryData", "2.2.0", "openAPI")
	request.Method = requests.POST
	return
}

// CreateQueryDataResponse creates a response to parse from QueryData response
func CreateQueryDataResponse() (response *QueryDataResponse) {
	response = &QueryDataResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
