package quickbi_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DataSetBlood invokes the quickbi_public.DataSetBlood API synchronously
func (client *Client) DataSetBlood(request *DataSetBloodRequest) (response *DataSetBloodResponse, err error) {
	response = CreateDataSetBloodResponse()
	err = client.DoAction(request, response)
	return
}

// DataSetBloodWithChan invokes the quickbi_public.DataSetBlood API asynchronously
func (client *Client) DataSetBloodWithChan(request *DataSetBloodRequest) (<-chan *DataSetBloodResponse, <-chan error) {
	responseChan := make(chan *DataSetBloodResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DataSetBlood(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DataSetBloodWithCallback invokes the quickbi_public.DataSetBlood API asynchronously
func (client *Client) DataSetBloodWithCallback(request *DataSetBloodRequest, callback func(response *DataSetBloodResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DataSetBloodResponse
		var err error
		defer close(result)
		response, err = client.DataSetBlood(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DataSetBloodRequest is the request struct for api DataSetBlood
type DataSetBloodRequest struct {
	*requests.RpcRequest
	DataSetIds  string `position:"Query" name:"DataSetIds"`
	WorksType   string `position:"Query" name:"WorksType"`
	AccessPoint string `position:"Query" name:"AccessPoint"`
	SignType    string `position:"Query" name:"SignType"`
	UserId      string `position:"Query" name:"UserId"`
}

// DataSetBloodResponse is the response struct for api DataSetBlood
type DataSetBloodResponse struct {
	*responses.BaseResponse
	RequestId string        `json:"RequestId" xml:"RequestId"`
	Success   bool          `json:"Success" xml:"Success"`
	Result    []WorksModels `json:"Result" xml:"Result"`
}

// CreateDataSetBloodRequest creates a request to invoke DataSetBlood API
func CreateDataSetBloodRequest() (request *DataSetBloodRequest) {
	request = &DataSetBloodRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("quickbi-public", "2022-01-01", "DataSetBlood", "2.2.0", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDataSetBloodResponse creates a response to parse from DataSetBlood response
func CreateDataSetBloodResponse() (response *DataSetBloodResponse) {
	response = &DataSetBloodResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
