package pts

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetJMeterSceneRunningData invokes the pts.GetJMeterSceneRunningData API synchronously
func (client *Client) GetJMeterSceneRunningData(request *GetJMeterSceneRunningDataRequest) (response *GetJMeterSceneRunningDataResponse, err error) {
	response = CreateGetJMeterSceneRunningDataResponse()
	err = client.DoAction(request, response)
	return
}

// GetJMeterSceneRunningDataWithChan invokes the pts.GetJMeterSceneRunningData API asynchronously
func (client *Client) GetJMeterSceneRunningDataWithChan(request *GetJMeterSceneRunningDataRequest) (<-chan *GetJMeterSceneRunningDataResponse, <-chan error) {
	responseChan := make(chan *GetJMeterSceneRunningDataResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetJMeterSceneRunningData(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetJMeterSceneRunningDataWithCallback invokes the pts.GetJMeterSceneRunningData API asynchronously
func (client *Client) GetJMeterSceneRunningDataWithCallback(request *GetJMeterSceneRunningDataRequest, callback func(response *GetJMeterSceneRunningDataResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetJMeterSceneRunningDataResponse
		var err error
		defer close(result)
		response, err = client.GetJMeterSceneRunningData(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetJMeterSceneRunningDataRequest is the request struct for api GetJMeterSceneRunningData
type GetJMeterSceneRunningDataRequest struct {
	*requests.RpcRequest
	SceneId string `position:"Query" name:"SceneId"`
}

// GetJMeterSceneRunningDataResponse is the response struct for api GetJMeterSceneRunningData
type GetJMeterSceneRunningDataResponse struct {
	*responses.BaseResponse
	Message        string      `json:"Message" xml:"Message"`
	RequestId      string      `json:"RequestId" xml:"RequestId"`
	Code           string      `json:"Code" xml:"Code"`
	Success        bool        `json:"Success" xml:"Success"`
	HttpStatusCode int         `json:"HttpStatusCode" xml:"HttpStatusCode"`
	DocumentUrl    string      `json:"DocumentUrl" xml:"DocumentUrl"`
	RunningData    RunningData `json:"RunningData" xml:"RunningData"`
}

// CreateGetJMeterSceneRunningDataRequest creates a request to invoke GetJMeterSceneRunningData API
func CreateGetJMeterSceneRunningDataRequest() (request *GetJMeterSceneRunningDataRequest) {
	request = &GetJMeterSceneRunningDataRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("PTS", "2020-10-20", "GetJMeterSceneRunningData", "", "")
	request.Method = requests.POST
	return
}

// CreateGetJMeterSceneRunningDataResponse creates a response to parse from GetJMeterSceneRunningData response
func CreateGetJMeterSceneRunningDataResponse() (response *GetJMeterSceneRunningDataResponse) {
	response = &GetJMeterSceneRunningDataResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
