package pts

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeletePtsSceneBaseLine invokes the pts.DeletePtsSceneBaseLine API synchronously
func (client *Client) DeletePtsSceneBaseLine(request *DeletePtsSceneBaseLineRequest) (response *DeletePtsSceneBaseLineResponse, err error) {
	response = CreateDeletePtsSceneBaseLineResponse()
	err = client.DoAction(request, response)
	return
}

// DeletePtsSceneBaseLineWithChan invokes the pts.DeletePtsSceneBaseLine API asynchronously
func (client *Client) DeletePtsSceneBaseLineWithChan(request *DeletePtsSceneBaseLineRequest) (<-chan *DeletePtsSceneBaseLineResponse, <-chan error) {
	responseChan := make(chan *DeletePtsSceneBaseLineResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeletePtsSceneBaseLine(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeletePtsSceneBaseLineWithCallback invokes the pts.DeletePtsSceneBaseLine API asynchronously
func (client *Client) DeletePtsSceneBaseLineWithCallback(request *DeletePtsSceneBaseLineRequest, callback func(response *DeletePtsSceneBaseLineResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeletePtsSceneBaseLineResponse
		var err error
		defer close(result)
		response, err = client.DeletePtsSceneBaseLine(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeletePtsSceneBaseLineRequest is the request struct for api DeletePtsSceneBaseLine
type DeletePtsSceneBaseLineRequest struct {
	*requests.RpcRequest
	SceneId string `position:"Query" name:"SceneId"`
}

// DeletePtsSceneBaseLineResponse is the response struct for api DeletePtsSceneBaseLine
type DeletePtsSceneBaseLineResponse struct {
	*responses.BaseResponse
	Message        string `json:"Message" xml:"Message"`
	RequestId      string `json:"RequestId" xml:"RequestId"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Code           string `json:"Code" xml:"Code"`
	Success        bool   `json:"Success" xml:"Success"`
}

// CreateDeletePtsSceneBaseLineRequest creates a request to invoke DeletePtsSceneBaseLine API
func CreateDeletePtsSceneBaseLineRequest() (request *DeletePtsSceneBaseLineRequest) {
	request = &DeletePtsSceneBaseLineRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("PTS", "2020-10-20", "DeletePtsSceneBaseLine", "", "")
	request.Method = requests.POST
	return
}

// CreateDeletePtsSceneBaseLineResponse creates a response to parse from DeletePtsSceneBaseLine response
func CreateDeletePtsSceneBaseLineResponse() (response *DeletePtsSceneBaseLineResponse) {
	response = &DeletePtsSceneBaseLineResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
