package privatelink

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// EnableVpcEndpointConnection invokes the privatelink.EnableVpcEndpointConnection API synchronously
func (client *Client) EnableVpcEndpointConnection(request *EnableVpcEndpointConnectionRequest) (response *EnableVpcEndpointConnectionResponse, err error) {
	response = CreateEnableVpcEndpointConnectionResponse()
	err = client.DoAction(request, response)
	return
}

// EnableVpcEndpointConnectionWithChan invokes the privatelink.EnableVpcEndpointConnection API asynchronously
func (client *Client) EnableVpcEndpointConnectionWithChan(request *EnableVpcEndpointConnectionRequest) (<-chan *EnableVpcEndpointConnectionResponse, <-chan error) {
	responseChan := make(chan *EnableVpcEndpointConnectionResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.EnableVpcEndpointConnection(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// EnableVpcEndpointConnectionWithCallback invokes the privatelink.EnableVpcEndpointConnection API asynchronously
func (client *Client) EnableVpcEndpointConnectionWithCallback(request *EnableVpcEndpointConnectionRequest, callback func(response *EnableVpcEndpointConnectionResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *EnableVpcEndpointConnectionResponse
		var err error
		defer close(result)
		response, err = client.EnableVpcEndpointConnection(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// EnableVpcEndpointConnectionRequest is the request struct for api EnableVpcEndpointConnection
type EnableVpcEndpointConnectionRequest struct {
	*requests.RpcRequest
	ClientToken string           `position:"Query" name:"ClientToken"`
	EndpointId  string           `position:"Query" name:"EndpointId"`
	DryRun      requests.Boolean `position:"Query" name:"DryRun"`
	Bandwidth   requests.Integer `position:"Query" name:"Bandwidth"`
	ServiceId   string           `position:"Query" name:"ServiceId"`
}

// EnableVpcEndpointConnectionResponse is the response struct for api EnableVpcEndpointConnection
type EnableVpcEndpointConnectionResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateEnableVpcEndpointConnectionRequest creates a request to invoke EnableVpcEndpointConnection API
func CreateEnableVpcEndpointConnectionRequest() (request *EnableVpcEndpointConnectionRequest) {
	request = &EnableVpcEndpointConnectionRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Privatelink", "2020-04-15", "EnableVpcEndpointConnection", "privatelink", "openAPI")
	request.Method = requests.POST
	return
}

// CreateEnableVpcEndpointConnectionResponse creates a response to parse from EnableVpcEndpointConnection response
func CreateEnableVpcEndpointConnectionResponse() (response *EnableVpcEndpointConnectionResponse) {
	response = &EnableVpcEndpointConnectionResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
