package pairecservice

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateTrafficControlTask invokes the pairecservice.CreateTrafficControlTask API synchronously
func (client *Client) CreateTrafficControlTask(request *CreateTrafficControlTaskRequest) (response *CreateTrafficControlTaskResponse, err error) {
	response = CreateCreateTrafficControlTaskResponse()
	err = client.DoAction(request, response)
	return
}

// CreateTrafficControlTaskWithChan invokes the pairecservice.CreateTrafficControlTask API asynchronously
func (client *Client) CreateTrafficControlTaskWithChan(request *CreateTrafficControlTaskRequest) (<-chan *CreateTrafficControlTaskResponse, <-chan error) {
	responseChan := make(chan *CreateTrafficControlTaskResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateTrafficControlTask(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateTrafficControlTaskWithCallback invokes the pairecservice.CreateTrafficControlTask API asynchronously
func (client *Client) CreateTrafficControlTaskWithCallback(request *CreateTrafficControlTaskRequest, callback func(response *CreateTrafficControlTaskResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateTrafficControlTaskResponse
		var err error
		defer close(result)
		response, err = client.CreateTrafficControlTask(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateTrafficControlTaskRequest is the request struct for api CreateTrafficControlTask
type CreateTrafficControlTaskRequest struct {
	*requests.RoaRequest
	Body string `position:"Body" name:"body"`
}

// CreateTrafficControlTaskResponse is the response struct for api CreateTrafficControlTask
type CreateTrafficControlTaskResponse struct {
	*responses.BaseResponse
	RequestId            string `json:"RequestId" xml:"RequestId"`
	TrafficControlTaskId string `json:"TrafficControlTaskId" xml:"TrafficControlTaskId"`
}

// CreateCreateTrafficControlTaskRequest creates a request to invoke CreateTrafficControlTask API
func CreateCreateTrafficControlTaskRequest() (request *CreateTrafficControlTaskRequest) {
	request = &CreateTrafficControlTaskRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("PaiRecService", "2022-12-13", "CreateTrafficControlTask", "/api/v1/trafficcontroltasks", "", "")
	request.Method = requests.POST
	return
}

// CreateCreateTrafficControlTaskResponse creates a response to parse from CreateTrafficControlTask response
func CreateCreateTrafficControlTaskResponse() (response *CreateTrafficControlTaskResponse) {
	response = &CreateTrafficControlTaskResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
