package paifeaturestore

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetModelFeatureFGInfo invokes the paifeaturestore.GetModelFeatureFGInfo API synchronously
func (client *Client) GetModelFeatureFGInfo(request *GetModelFeatureFGInfoRequest) (response *GetModelFeatureFGInfoResponse, err error) {
	response = CreateGetModelFeatureFGInfoResponse()
	err = client.DoAction(request, response)
	return
}

// GetModelFeatureFGInfoWithChan invokes the paifeaturestore.GetModelFeatureFGInfo API asynchronously
func (client *Client) GetModelFeatureFGInfoWithChan(request *GetModelFeatureFGInfoRequest) (<-chan *GetModelFeatureFGInfoResponse, <-chan error) {
	responseChan := make(chan *GetModelFeatureFGInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetModelFeatureFGInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetModelFeatureFGInfoWithCallback invokes the paifeaturestore.GetModelFeatureFGInfo API asynchronously
func (client *Client) GetModelFeatureFGInfoWithCallback(request *GetModelFeatureFGInfoRequest, callback func(response *GetModelFeatureFGInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetModelFeatureFGInfoResponse
		var err error
		defer close(result)
		response, err = client.GetModelFeatureFGInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetModelFeatureFGInfoRequest is the request struct for api GetModelFeatureFGInfo
type GetModelFeatureFGInfoRequest struct {
	*requests.RoaRequest
	ModelFeatureId string `position:"Path" name:"ModelFeatureId"`
	InstanceId     string `position:"Path" name:"InstanceId"`
}

// GetModelFeatureFGInfoResponse is the response struct for api GetModelFeatureFGInfo
type GetModelFeatureFGInfoResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Content   string `json:"Content" xml:"Content"`
}

// CreateGetModelFeatureFGInfoRequest creates a request to invoke GetModelFeatureFGInfo API
func CreateGetModelFeatureFGInfoRequest() (request *GetModelFeatureFGInfoRequest) {
	request = &GetModelFeatureFGInfoRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("PaiFeatureStore", "2023-06-21", "GetModelFeatureFGInfo", "/api/v1/instances/[InstanceId]/modelfeatures/[ModelFeatureId]/fginfo", "", "")
	request.Method = requests.GET
	return
}

// CreateGetModelFeatureFGInfoResponse creates a response to parse from GetModelFeatureFGInfo response
func CreateGetModelFeatureFGInfoResponse() (response *GetModelFeatureFGInfoResponse) {
	response = &GetModelFeatureFGInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
