package mpaas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateMsacStageAppMapping invokes the mpaas.CreateMsacStageAppMapping API synchronously
func (client *Client) CreateMsacStageAppMapping(request *CreateMsacStageAppMappingRequest) (response *CreateMsacStageAppMappingResponse, err error) {
	response = CreateCreateMsacStageAppMappingResponse()
	err = client.DoAction(request, response)
	return
}

// CreateMsacStageAppMappingWithChan invokes the mpaas.CreateMsacStageAppMapping API asynchronously
func (client *Client) CreateMsacStageAppMappingWithChan(request *CreateMsacStageAppMappingRequest) (<-chan *CreateMsacStageAppMappingResponse, <-chan error) {
	responseChan := make(chan *CreateMsacStageAppMappingResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateMsacStageAppMapping(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateMsacStageAppMappingWithCallback invokes the mpaas.CreateMsacStageAppMapping API asynchronously
func (client *Client) CreateMsacStageAppMappingWithCallback(request *CreateMsacStageAppMappingRequest, callback func(response *CreateMsacStageAppMappingResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateMsacStageAppMappingResponse
		var err error
		defer close(result)
		response, err = client.CreateMsacStageAppMapping(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateMsacStageAppMappingRequest is the request struct for api CreateMsacStageAppMapping
type CreateMsacStageAppMappingRequest struct {
	*requests.RpcRequest
	TenantId                                        string `position:"Body" name:"TenantId"`
	MpaasMappcenterMsacCreateStageAppMappingJsonStr string `position:"Body" name:"MpaasMappcenterMsacCreateStageAppMappingJsonStr"`
	AppId                                           string `position:"Body" name:"AppId"`
	WorkspaceId                                     string `position:"Body" name:"WorkspaceId"`
}

// CreateMsacStageAppMappingResponse is the response struct for api CreateMsacStageAppMapping
type CreateMsacStageAppMappingResponse struct {
	*responses.BaseResponse
	ResultMessage string                                   `json:"ResultMessage" xml:"ResultMessage"`
	ResultCode    string                                   `json:"ResultCode" xml:"ResultCode"`
	RequestId     string                                   `json:"RequestId" xml:"RequestId"`
	ResultContent ResultContentInCreateMsacStageAppMapping `json:"ResultContent" xml:"ResultContent"`
}

// CreateCreateMsacStageAppMappingRequest creates a request to invoke CreateMsacStageAppMapping API
func CreateCreateMsacStageAppMappingRequest() (request *CreateMsacStageAppMappingRequest) {
	request = &CreateMsacStageAppMappingRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("mPaaS", "2020-10-28", "CreateMsacStageAppMapping", "", "")
	request.Method = requests.POST
	return
}

// CreateCreateMsacStageAppMappingResponse creates a response to parse from CreateMsacStageAppMapping response
func CreateCreateMsacStageAppMappingResponse() (response *CreateMsacStageAppMappingResponse) {
	response = &CreateMsacStageAppMappingResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
