package mpaas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateMcdpEvent invokes the mpaas.CreateMcdpEvent API synchronously
func (client *Client) CreateMcdpEvent(request *CreateMcdpEventRequest) (response *CreateMcdpEventResponse, err error) {
	response = CreateCreateMcdpEventResponse()
	err = client.DoAction(request, response)
	return
}

// CreateMcdpEventWithChan invokes the mpaas.CreateMcdpEvent API asynchronously
func (client *Client) CreateMcdpEventWithChan(request *CreateMcdpEventRequest) (<-chan *CreateMcdpEventResponse, <-chan error) {
	responseChan := make(chan *CreateMcdpEventResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateMcdpEvent(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateMcdpEventWithCallback invokes the mpaas.CreateMcdpEvent API asynchronously
func (client *Client) CreateMcdpEventWithCallback(request *CreateMcdpEventRequest, callback func(response *CreateMcdpEventResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateMcdpEventResponse
		var err error
		defer close(result)
		response, err = client.CreateMcdpEvent(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateMcdpEventRequest is the request struct for api CreateMcdpEvent
type CreateMcdpEventRequest struct {
	*requests.RpcRequest
	TenantId                              string `position:"Body" name:"TenantId"`
	MpaasMappcenterMcdpEventCreateJsonStr string `position:"Body" name:"MpaasMappcenterMcdpEventCreateJsonStr"`
	AppId                                 string `position:"Body" name:"AppId"`
	WorkspaceId                           string `position:"Body" name:"WorkspaceId"`
}

// CreateMcdpEventResponse is the response struct for api CreateMcdpEvent
type CreateMcdpEventResponse struct {
	*responses.BaseResponse
	ResultMessage string                         `json:"ResultMessage" xml:"ResultMessage"`
	ResultCode    string                         `json:"ResultCode" xml:"ResultCode"`
	RequestId     string                         `json:"RequestId" xml:"RequestId"`
	ResultContent ResultContentInCreateMcdpEvent `json:"ResultContent" xml:"ResultContent"`
}

// CreateCreateMcdpEventRequest creates a request to invoke CreateMcdpEvent API
func CreateCreateMcdpEventRequest() (request *CreateMcdpEventRequest) {
	request = &CreateMcdpEventRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("mPaaS", "2020-10-28", "CreateMcdpEvent", "", "")
	request.Method = requests.POST
	return
}

// CreateCreateMcdpEventResponse creates a response to parse from CreateMcdpEvent response
func CreateCreateMcdpEventResponse() (response *CreateMcdpEventResponse) {
	response = &CreateMcdpEventResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
