package lto

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetEdgeTotalDeviceCount invokes the lto.GetEdgeTotalDeviceCount API synchronously
func (client *Client) GetEdgeTotalDeviceCount(request *GetEdgeTotalDeviceCountRequest) (response *GetEdgeTotalDeviceCountResponse, err error) {
	response = CreateGetEdgeTotalDeviceCountResponse()
	err = client.DoAction(request, response)
	return
}

// GetEdgeTotalDeviceCountWithChan invokes the lto.GetEdgeTotalDeviceCount API asynchronously
func (client *Client) GetEdgeTotalDeviceCountWithChan(request *GetEdgeTotalDeviceCountRequest) (<-chan *GetEdgeTotalDeviceCountResponse, <-chan error) {
	responseChan := make(chan *GetEdgeTotalDeviceCountResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetEdgeTotalDeviceCount(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetEdgeTotalDeviceCountWithCallback invokes the lto.GetEdgeTotalDeviceCount API asynchronously
func (client *Client) GetEdgeTotalDeviceCountWithCallback(request *GetEdgeTotalDeviceCountRequest, callback func(response *GetEdgeTotalDeviceCountResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetEdgeTotalDeviceCountResponse
		var err error
		defer close(result)
		response, err = client.GetEdgeTotalDeviceCount(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetEdgeTotalDeviceCountRequest is the request struct for api GetEdgeTotalDeviceCount
type GetEdgeTotalDeviceCountRequest struct {
	*requests.RpcRequest
}

// GetEdgeTotalDeviceCountResponse is the response struct for api GetEdgeTotalDeviceCount
type GetEdgeTotalDeviceCountResponse struct {
	*responses.BaseResponse
	Code           string `json:"Code" xml:"Code"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Message        string `json:"Message" xml:"Message"`
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
	Data           int64  `json:"Data" xml:"Data"`
}

// CreateGetEdgeTotalDeviceCountRequest creates a request to invoke GetEdgeTotalDeviceCount API
func CreateGetEdgeTotalDeviceCountRequest() (request *GetEdgeTotalDeviceCountRequest) {
	request = &GetEdgeTotalDeviceCountRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("lto", "2021-07-07", "GetEdgeTotalDeviceCount", "", "")
	request.Method = requests.POST
	return
}

// CreateGetEdgeTotalDeviceCountResponse creates a response to parse from GetEdgeTotalDeviceCount response
func CreateGetEdgeTotalDeviceCountResponse() (response *GetEdgeTotalDeviceCountResponse) {
	response = &GetEdgeTotalDeviceCountResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
