package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListEventSubEvent invokes the live.ListEventSubEvent API synchronously
func (client *Client) ListEventSubEvent(request *ListEventSubEventRequest) (response *ListEventSubEventResponse, err error) {
	response = CreateListEventSubEventResponse()
	err = client.DoAction(request, response)
	return
}

// ListEventSubEventWithChan invokes the live.ListEventSubEvent API asynchronously
func (client *Client) ListEventSubEventWithChan(request *ListEventSubEventRequest) (<-chan *ListEventSubEventResponse, <-chan error) {
	responseChan := make(chan *ListEventSubEventResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListEventSubEvent(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListEventSubEventWithCallback invokes the live.ListEventSubEvent API asynchronously
func (client *Client) ListEventSubEventWithCallback(request *ListEventSubEventRequest, callback func(response *ListEventSubEventResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListEventSubEventResponse
		var err error
		defer close(result)
		response, err = client.ListEventSubEvent(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListEventSubEventRequest is the request struct for api ListEventSubEvent
type ListEventSubEventRequest struct {
	*requests.RpcRequest
	SubscribeId string           `position:"Query" name:"SubscribeId"`
	EndTime     requests.Integer `position:"Query" name:"EndTime"`
	StartTime   requests.Integer `position:"Query" name:"StartTime"`
	PageNo      requests.Integer `position:"Query" name:"PageNo"`
	AppId       string           `position:"Query" name:"AppId"`
	PageSize    requests.Integer `position:"Query" name:"PageSize"`
}

// ListEventSubEventResponse is the response struct for api ListEventSubEvent
type ListEventSubEventResponse struct {
	*responses.BaseResponse
	RequestId string     `json:"RequestId" xml:"RequestId"`
	Count     int64      `json:"Count" xml:"Count"`
	HasMore   bool       `json:"HasMore" xml:"HasMore"`
	Logs      []LogsItem `json:"Logs" xml:"Logs"`
}

// CreateListEventSubEventRequest creates a request to invoke ListEventSubEvent API
func CreateListEventSubEventRequest() (request *ListEventSubEventRequest) {
	request = &ListEventSubEventRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "ListEventSubEvent", "live", "openAPI")
	request.Method = requests.GET
	return
}

// CreateListEventSubEventResponse creates a response to parse from ListEventSubEvent response
func CreateListEventSubEventResponse() (response *ListEventSubEventResponse) {
	response = &ListEventSubEventResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
