package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetEdgeTranscodeTemplate invokes the live.GetEdgeTranscodeTemplate API synchronously
func (client *Client) GetEdgeTranscodeTemplate(request *GetEdgeTranscodeTemplateRequest) (response *GetEdgeTranscodeTemplateResponse, err error) {
	response = CreateGetEdgeTranscodeTemplateResponse()
	err = client.DoAction(request, response)
	return
}

// GetEdgeTranscodeTemplateWithChan invokes the live.GetEdgeTranscodeTemplate API asynchronously
func (client *Client) GetEdgeTranscodeTemplateWithChan(request *GetEdgeTranscodeTemplateRequest) (<-chan *GetEdgeTranscodeTemplateResponse, <-chan error) {
	responseChan := make(chan *GetEdgeTranscodeTemplateResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetEdgeTranscodeTemplate(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetEdgeTranscodeTemplateWithCallback invokes the live.GetEdgeTranscodeTemplate API asynchronously
func (client *Client) GetEdgeTranscodeTemplateWithCallback(request *GetEdgeTranscodeTemplateRequest, callback func(response *GetEdgeTranscodeTemplateResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetEdgeTranscodeTemplateResponse
		var err error
		defer close(result)
		response, err = client.GetEdgeTranscodeTemplate(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetEdgeTranscodeTemplateRequest is the request struct for api GetEdgeTranscodeTemplate
type GetEdgeTranscodeTemplateRequest struct {
	*requests.RpcRequest
	ClusterId  string           `position:"Query" name:"ClusterId"`
	OwnerId    requests.Integer `position:"Query" name:"OwnerId"`
	TemplateId string           `position:"Query" name:"TemplateId"`
}

// GetEdgeTranscodeTemplateResponse is the response struct for api GetEdgeTranscodeTemplate
type GetEdgeTranscodeTemplateResponse struct {
	*responses.BaseResponse
	RequestId string   `json:"RequestId" xml:"RequestId"`
	Template  Template `json:"Template" xml:"Template"`
}

// CreateGetEdgeTranscodeTemplateRequest creates a request to invoke GetEdgeTranscodeTemplate API
func CreateGetEdgeTranscodeTemplateRequest() (request *GetEdgeTranscodeTemplateRequest) {
	request = &GetEdgeTranscodeTemplateRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "GetEdgeTranscodeTemplate", "live", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetEdgeTranscodeTemplateResponse creates a response to parse from GetEdgeTranscodeTemplate response
func CreateGetEdgeTranscodeTemplateResponse() (response *GetEdgeTranscodeTemplateResponse) {
	response = &GetEdgeTranscodeTemplateResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
