package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeLiveDomainRealTimeHttpCodeData invokes the live.DescribeLiveDomainRealTimeHttpCodeData API synchronously
func (client *Client) DescribeLiveDomainRealTimeHttpCodeData(request *DescribeLiveDomainRealTimeHttpCodeDataRequest) (response *DescribeLiveDomainRealTimeHttpCodeDataResponse, err error) {
	response = CreateDescribeLiveDomainRealTimeHttpCodeDataResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeLiveDomainRealTimeHttpCodeDataWithChan invokes the live.DescribeLiveDomainRealTimeHttpCodeData API asynchronously
func (client *Client) DescribeLiveDomainRealTimeHttpCodeDataWithChan(request *DescribeLiveDomainRealTimeHttpCodeDataRequest) (<-chan *DescribeLiveDomainRealTimeHttpCodeDataResponse, <-chan error) {
	responseChan := make(chan *DescribeLiveDomainRealTimeHttpCodeDataResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeLiveDomainRealTimeHttpCodeData(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeLiveDomainRealTimeHttpCodeDataWithCallback invokes the live.DescribeLiveDomainRealTimeHttpCodeData API asynchronously
func (client *Client) DescribeLiveDomainRealTimeHttpCodeDataWithCallback(request *DescribeLiveDomainRealTimeHttpCodeDataRequest, callback func(response *DescribeLiveDomainRealTimeHttpCodeDataResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeLiveDomainRealTimeHttpCodeDataResponse
		var err error
		defer close(result)
		response, err = client.DescribeLiveDomainRealTimeHttpCodeData(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeLiveDomainRealTimeHttpCodeDataRequest is the request struct for api DescribeLiveDomainRealTimeHttpCodeData
type DescribeLiveDomainRealTimeHttpCodeDataRequest struct {
	*requests.RpcRequest
	LocationNameEn string           `position:"Query" name:"LocationNameEn"`
	StartTime      string           `position:"Query" name:"StartTime"`
	IspNameEn      string           `position:"Query" name:"IspNameEn"`
	DomainName     string           `position:"Query" name:"DomainName"`
	EndTime        string           `position:"Query" name:"EndTime"`
	OwnerId        requests.Integer `position:"Query" name:"OwnerId"`
}

// DescribeLiveDomainRealTimeHttpCodeDataResponse is the response struct for api DescribeLiveDomainRealTimeHttpCodeData
type DescribeLiveDomainRealTimeHttpCodeDataResponse struct {
	*responses.BaseResponse
	EndTime              string               `json:"EndTime" xml:"EndTime"`
	StartTime            string               `json:"StartTime" xml:"StartTime"`
	RequestId            string               `json:"RequestId" xml:"RequestId"`
	DomainName           string               `json:"DomainName" xml:"DomainName"`
	DataInterval         string               `json:"DataInterval" xml:"DataInterval"`
	RealTimeHttpCodeData RealTimeHttpCodeData `json:"RealTimeHttpCodeData" xml:"RealTimeHttpCodeData"`
}

// CreateDescribeLiveDomainRealTimeHttpCodeDataRequest creates a request to invoke DescribeLiveDomainRealTimeHttpCodeData API
func CreateDescribeLiveDomainRealTimeHttpCodeDataRequest() (request *DescribeLiveDomainRealTimeHttpCodeDataRequest) {
	request = &DescribeLiveDomainRealTimeHttpCodeDataRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "DescribeLiveDomainRealTimeHttpCodeData", "live", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeLiveDomainRealTimeHttpCodeDataResponse creates a response to parse from DescribeLiveDomainRealTimeHttpCodeData response
func CreateDescribeLiveDomainRealTimeHttpCodeDataResponse() (response *DescribeLiveDomainRealTimeHttpCodeDataResponse) {
	response = &DescribeLiveDomainRealTimeHttpCodeDataResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
