package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateMixStream invokes the live.CreateMixStream API synchronously
func (client *Client) CreateMixStream(request *CreateMixStreamRequest) (response *CreateMixStreamResponse, err error) {
	response = CreateCreateMixStreamResponse()
	err = client.DoAction(request, response)
	return
}

// CreateMixStreamWithChan invokes the live.CreateMixStream API asynchronously
func (client *Client) CreateMixStreamWithChan(request *CreateMixStreamRequest) (<-chan *CreateMixStreamResponse, <-chan error) {
	responseChan := make(chan *CreateMixStreamResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateMixStream(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateMixStreamWithCallback invokes the live.CreateMixStream API asynchronously
func (client *Client) CreateMixStreamWithCallback(request *CreateMixStreamRequest, callback func(response *CreateMixStreamResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateMixStreamResponse
		var err error
		defer close(result)
		response, err = client.CreateMixStream(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateMixStreamRequest is the request struct for api CreateMixStream
type CreateMixStreamRequest struct {
	*requests.RpcRequest
	OutputConfig    string           `position:"Query" name:"OutputConfig"`
	LayoutId        string           `position:"Query" name:"LayoutId"`
	DomainName      string           `position:"Query" name:"DomainName"`
	InputStreamList string           `position:"Query" name:"InputStreamList"`
	OwnerId         requests.Integer `position:"Query" name:"OwnerId"`
	CallbackConfig  string           `position:"Query" name:"CallbackConfig"`
}

// CreateMixStreamResponse is the response struct for api CreateMixStream
type CreateMixStreamResponse struct {
	*responses.BaseResponse
	MixStreamId string `json:"MixStreamId" xml:"MixStreamId"`
	RequestId   string `json:"RequestId" xml:"RequestId"`
}

// CreateCreateMixStreamRequest creates a request to invoke CreateMixStream API
func CreateCreateMixStreamRequest() (request *CreateMixStreamRequest) {
	request = &CreateMixStreamRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "CreateMixStream", "live", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateMixStreamResponse creates a response to parse from CreateMixStream response
func CreateCreateMixStreamResponse() (response *CreateMixStreamResponse) {
	response = &CreateMixStreamResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
