package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateMessageGroup invokes the live.CreateMessageGroup API synchronously
func (client *Client) CreateMessageGroup(request *CreateMessageGroupRequest) (response *CreateMessageGroupResponse, err error) {
	response = CreateCreateMessageGroupResponse()
	err = client.DoAction(request, response)
	return
}

// CreateMessageGroupWithChan invokes the live.CreateMessageGroup API asynchronously
func (client *Client) CreateMessageGroupWithChan(request *CreateMessageGroupRequest) (<-chan *CreateMessageGroupResponse, <-chan error) {
	responseChan := make(chan *CreateMessageGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateMessageGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateMessageGroupWithCallback invokes the live.CreateMessageGroup API asynchronously
func (client *Client) CreateMessageGroupWithCallback(request *CreateMessageGroupRequest, callback func(response *CreateMessageGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateMessageGroupResponse
		var err error
		defer close(result)
		response, err = client.CreateMessageGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateMessageGroupRequest is the request struct for api CreateMessageGroup
type CreateMessageGroupRequest struct {
	*requests.RpcRequest
	Extension map[string]string `position:"Body" name:"Extension"  type:"Map"`
	CreatorId string            `position:"Body" name:"CreatorId"`
	AppId     string            `position:"Body" name:"AppId"`
}

// CreateMessageGroupResponse is the response struct for api CreateMessageGroup
type CreateMessageGroupResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Result    Result `json:"Result" xml:"Result"`
}

// CreateCreateMessageGroupRequest creates a request to invoke CreateMessageGroup API
func CreateCreateMessageGroupRequest() (request *CreateMessageGroupRequest) {
	request = &CreateMessageGroupRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "CreateMessageGroup", "live", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateMessageGroupResponse creates a response to parse from CreateMessageGroup response
func CreateCreateMessageGroupResponse() (response *CreateMessageGroupResponse) {
	response = &CreateMessageGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
