package iot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateTopicConfig invokes the iot.CreateTopicConfig API synchronously
func (client *Client) CreateTopicConfig(request *CreateTopicConfigRequest) (response *CreateTopicConfigResponse, err error) {
	response = CreateCreateTopicConfigResponse()
	err = client.DoAction(request, response)
	return
}

// CreateTopicConfigWithChan invokes the iot.CreateTopicConfig API asynchronously
func (client *Client) CreateTopicConfigWithChan(request *CreateTopicConfigRequest) (<-chan *CreateTopicConfigResponse, <-chan error) {
	responseChan := make(chan *CreateTopicConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateTopicConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateTopicConfigWithCallback invokes the iot.CreateTopicConfig API asynchronously
func (client *Client) CreateTopicConfigWithCallback(request *CreateTopicConfigRequest, callback func(response *CreateTopicConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateTopicConfigResponse
		var err error
		defer close(result)
		response, err = client.CreateTopicConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateTopicConfigRequest is the request struct for api CreateTopicConfig
type CreateTopicConfigRequest struct {
	*requests.RpcRequest
	Description          string           `position:"Query" name:"Description"`
	IotInstanceId        string           `position:"Query" name:"IotInstanceId"`
	TopicFullName        string           `position:"Query" name:"TopicFullName"`
	EnableBroadcast      requests.Boolean `position:"Query" name:"EnableBroadcast"`
	EnableProxySubscribe requests.Boolean `position:"Query" name:"EnableProxySubscribe"`
	ProductKey           string           `position:"Query" name:"ProductKey"`
	Codec                string           `position:"Query" name:"Codec"`
	ApiProduct           string           `position:"Body" name:"ApiProduct"`
	ApiRevision          string           `position:"Body" name:"ApiRevision"`
	Operation            string           `position:"Query" name:"Operation"`
}

// CreateTopicConfigResponse is the response struct for api CreateTopicConfig
type CreateTopicConfigResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
}

// CreateCreateTopicConfigRequest creates a request to invoke CreateTopicConfig API
func CreateCreateTopicConfigRequest() (request *CreateTopicConfigRequest) {
	request = &CreateTopicConfigRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Iot", "2018-01-20", "CreateTopicConfig", "iot", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateTopicConfigResponse creates a response to parse from CreateTopicConfig response
func CreateCreateTopicConfigResponse() (response *CreateTopicConfigResponse) {
	response = &CreateTopicConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
