package iot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateEdgeInstance invokes the iot.CreateEdgeInstance API synchronously
func (client *Client) CreateEdgeInstance(request *CreateEdgeInstanceRequest) (response *CreateEdgeInstanceResponse, err error) {
	response = CreateCreateEdgeInstanceResponse()
	err = client.DoAction(request, response)
	return
}

// CreateEdgeInstanceWithChan invokes the iot.CreateEdgeInstance API asynchronously
func (client *Client) CreateEdgeInstanceWithChan(request *CreateEdgeInstanceRequest) (<-chan *CreateEdgeInstanceResponse, <-chan error) {
	responseChan := make(chan *CreateEdgeInstanceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateEdgeInstance(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateEdgeInstanceWithCallback invokes the iot.CreateEdgeInstance API asynchronously
func (client *Client) CreateEdgeInstanceWithCallback(request *CreateEdgeInstanceRequest, callback func(response *CreateEdgeInstanceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateEdgeInstanceResponse
		var err error
		defer close(result)
		response, err = client.CreateEdgeInstance(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateEdgeInstanceRequest is the request struct for api CreateEdgeInstance
type CreateEdgeInstanceRequest struct {
	*requests.RpcRequest
	Spec          requests.Integer `position:"Query" name:"Spec"`
	IotInstanceId string           `position:"Query" name:"IotInstanceId"`
	Tags          string           `position:"Query" name:"Tags"`
	ApiProduct    string           `position:"Body" name:"ApiProduct"`
	Name          string           `position:"Query" name:"Name"`
	ApiRevision   string           `position:"Body" name:"ApiRevision"`
}

// CreateEdgeInstanceResponse is the response struct for api CreateEdgeInstance
type CreateEdgeInstanceResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	Success      bool   `json:"Success" xml:"Success"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	Code         string `json:"Code" xml:"Code"`
	InstanceId   string `json:"InstanceId" xml:"InstanceId"`
}

// CreateCreateEdgeInstanceRequest creates a request to invoke CreateEdgeInstance API
func CreateCreateEdgeInstanceRequest() (request *CreateEdgeInstanceRequest) {
	request = &CreateEdgeInstanceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Iot", "2018-01-20", "CreateEdgeInstance", "iot", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateEdgeInstanceResponse creates a response to parse from CreateEdgeInstance response
func CreateCreateEdgeInstanceResponse() (response *CreateEdgeInstanceResponse) {
	response = &CreateEdgeInstanceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
