package hitsdb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpgradeLindormInstance invokes the hitsdb.UpgradeLindormInstance API synchronously
func (client *Client) UpgradeLindormInstance(request *UpgradeLindormInstanceRequest) (response *UpgradeLindormInstanceResponse, err error) {
	response = CreateUpgradeLindormInstanceResponse()
	err = client.DoAction(request, response)
	return
}

// UpgradeLindormInstanceWithChan invokes the hitsdb.UpgradeLindormInstance API asynchronously
func (client *Client) UpgradeLindormInstanceWithChan(request *UpgradeLindormInstanceRequest) (<-chan *UpgradeLindormInstanceResponse, <-chan error) {
	responseChan := make(chan *UpgradeLindormInstanceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpgradeLindormInstance(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpgradeLindormInstanceWithCallback invokes the hitsdb.UpgradeLindormInstance API asynchronously
func (client *Client) UpgradeLindormInstanceWithCallback(request *UpgradeLindormInstanceRequest, callback func(response *UpgradeLindormInstanceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpgradeLindormInstanceResponse
		var err error
		defer close(result)
		response, err = client.UpgradeLindormInstance(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpgradeLindormInstanceRequest is the request struct for api UpgradeLindormInstance
type UpgradeLindormInstanceRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	LogSpec              string           `position:"Query" name:"LogSpec"`
	SecurityToken        string           `position:"Query" name:"SecurityToken"`
	TsdbNum              requests.Integer `position:"Query" name:"TsdbNum"`
	SolrNum              requests.Integer `position:"Query" name:"SolrNum"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	LindormNum           requests.Integer `position:"Query" name:"LindormNum"`
	LtsCoreNum           requests.Integer `position:"Query" name:"LtsCoreNum"`
	InstanceId           string           `position:"Query" name:"InstanceId"`
	MlNum                requests.Integer `position:"Query" name:"MlNum"`
	StreamNum            requests.Integer `position:"Query" name:"StreamNum"`
	LogSingleStorage     requests.Integer `position:"Query" name:"LogSingleStorage"`
	ZoneId               string           `position:"Query" name:"ZoneId"`
	ClientToken          string           `position:"Query" name:"ClientToken"`
	UpgradeType          string           `position:"Query" name:"UpgradeType"`
	TsdbSpec             string           `position:"Query" name:"TsdbSpec"`
	FilestoreSpec        string           `position:"Query" name:"FilestoreSpec"`
	LindormSpec          string           `position:"Query" name:"LindormSpec"`
	ColdStorage          requests.Integer `position:"Query" name:"ColdStorage"`
	LogNum               requests.Integer `position:"Query" name:"LogNum"`
	SolrSpec             string           `position:"Query" name:"SolrSpec"`
	CoreSingleStorage    requests.Integer `position:"Query" name:"CoreSingleStorage"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	FilestoreNum         requests.Integer `position:"Query" name:"FilestoreNum"`
	StreamSpec           string           `position:"Query" name:"StreamSpec"`
	MlSpec               string           `position:"Query" name:"MlSpec"`
	LtsCoreSpec          string           `position:"Query" name:"LtsCoreSpec"`
	ClusterStorage       requests.Integer `position:"Query" name:"ClusterStorage"`
}

// UpgradeLindormInstanceResponse is the response struct for api UpgradeLindormInstance
type UpgradeLindormInstanceResponse struct {
	*responses.BaseResponse
	OrderId   int64  `json:"OrderId" xml:"OrderId"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateUpgradeLindormInstanceRequest creates a request to invoke UpgradeLindormInstance API
func CreateUpgradeLindormInstanceRequest() (request *UpgradeLindormInstanceRequest) {
	request = &UpgradeLindormInstanceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("hitsdb", "2020-06-15", "UpgradeLindormInstance", "hitsdb", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpgradeLindormInstanceResponse creates a response to parse from UpgradeLindormInstance response
func CreateUpgradeLindormInstanceResponse() (response *UpgradeLindormInstanceResponse) {
	response = &UpgradeLindormInstanceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
