package gpdb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SetDBInstancePlanStatus invokes the gpdb.SetDBInstancePlanStatus API synchronously
func (client *Client) SetDBInstancePlanStatus(request *SetDBInstancePlanStatusRequest) (response *SetDBInstancePlanStatusResponse, err error) {
	response = CreateSetDBInstancePlanStatusResponse()
	err = client.DoAction(request, response)
	return
}

// SetDBInstancePlanStatusWithChan invokes the gpdb.SetDBInstancePlanStatus API asynchronously
func (client *Client) SetDBInstancePlanStatusWithChan(request *SetDBInstancePlanStatusRequest) (<-chan *SetDBInstancePlanStatusResponse, <-chan error) {
	responseChan := make(chan *SetDBInstancePlanStatusResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SetDBInstancePlanStatus(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SetDBInstancePlanStatusWithCallback invokes the gpdb.SetDBInstancePlanStatus API asynchronously
func (client *Client) SetDBInstancePlanStatusWithCallback(request *SetDBInstancePlanStatusRequest, callback func(response *SetDBInstancePlanStatusResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SetDBInstancePlanStatusResponse
		var err error
		defer close(result)
		response, err = client.SetDBInstancePlanStatus(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SetDBInstancePlanStatusRequest is the request struct for api SetDBInstancePlanStatus
type SetDBInstancePlanStatusRequest struct {
	*requests.RpcRequest
	PlanStatus   string           `position:"Query" name:"PlanStatus"`
	DBInstanceId string           `position:"Query" name:"DBInstanceId"`
	OwnerId      requests.Integer `position:"Query" name:"OwnerId"`
	PlanId       string           `position:"Query" name:"PlanId"`
}

// SetDBInstancePlanStatusResponse is the response struct for api SetDBInstancePlanStatus
type SetDBInstancePlanStatusResponse struct {
	*responses.BaseResponse
	Status       string `json:"Status" xml:"Status"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	PlanId       string `json:"PlanId" xml:"PlanId"`
	RequestId    string `json:"RequestId" xml:"RequestId"`
}

// CreateSetDBInstancePlanStatusRequest creates a request to invoke SetDBInstancePlanStatus API
func CreateSetDBInstancePlanStatusRequest() (request *SetDBInstancePlanStatusRequest) {
	request = &SetDBInstancePlanStatusRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("gpdb", "2016-05-03", "SetDBInstancePlanStatus", "", "")
	request.Method = requests.POST
	return
}

// CreateSetDBInstancePlanStatusResponse creates a response to parse from SetDBInstancePlanStatus response
func CreateSetDBInstancePlanStatusResponse() (response *SetDBInstancePlanStatusResponse) {
	response = &SetDBInstancePlanStatusResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
