package ens

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteStorageGateway invokes the ens.DeleteStorageGateway API synchronously
func (client *Client) DeleteStorageGateway(request *DeleteStorageGatewayRequest) (response *DeleteStorageGatewayResponse, err error) {
	response = CreateDeleteStorageGatewayResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteStorageGatewayWithChan invokes the ens.DeleteStorageGateway API asynchronously
func (client *Client) DeleteStorageGatewayWithChan(request *DeleteStorageGatewayRequest) (<-chan *DeleteStorageGatewayResponse, <-chan error) {
	responseChan := make(chan *DeleteStorageGatewayResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteStorageGateway(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteStorageGatewayWithCallback invokes the ens.DeleteStorageGateway API asynchronously
func (client *Client) DeleteStorageGatewayWithCallback(request *DeleteStorageGatewayRequest, callback func(response *DeleteStorageGatewayResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteStorageGatewayResponse
		var err error
		defer close(result)
		response, err = client.DeleteStorageGateway(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteStorageGatewayRequest is the request struct for api DeleteStorageGateway
type DeleteStorageGatewayRequest struct {
	*requests.RpcRequest
	GatewayId string `position:"Query" name:"GatewayId"`
}

// DeleteStorageGatewayResponse is the response struct for api DeleteStorageGateway
type DeleteStorageGatewayResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteStorageGatewayRequest creates a request to invoke DeleteStorageGateway API
func CreateDeleteStorageGatewayRequest() (request *DeleteStorageGatewayRequest) {
	request = &DeleteStorageGatewayRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ens", "2017-11-10", "DeleteStorageGateway", "ens", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteStorageGatewayResponse creates a response to parse from DeleteStorageGateway response
func CreateDeleteStorageGatewayResponse() (response *DeleteStorageGatewayResponse) {
	response = &DeleteStorageGatewayResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
