package ecs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeSavingsPlanPrice invokes the ecs.DescribeSavingsPlanPrice API synchronously
func (client *Client) DescribeSavingsPlanPrice(request *DescribeSavingsPlanPriceRequest) (response *DescribeSavingsPlanPriceResponse, err error) {
	response = CreateDescribeSavingsPlanPriceResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeSavingsPlanPriceWithChan invokes the ecs.DescribeSavingsPlanPrice API asynchronously
func (client *Client) DescribeSavingsPlanPriceWithChan(request *DescribeSavingsPlanPriceRequest) (<-chan *DescribeSavingsPlanPriceResponse, <-chan error) {
	responseChan := make(chan *DescribeSavingsPlanPriceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeSavingsPlanPrice(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeSavingsPlanPriceWithCallback invokes the ecs.DescribeSavingsPlanPrice API asynchronously
func (client *Client) DescribeSavingsPlanPriceWithCallback(request *DescribeSavingsPlanPriceRequest, callback func(response *DescribeSavingsPlanPriceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeSavingsPlanPriceResponse
		var err error
		defer close(result)
		response, err = client.DescribeSavingsPlanPrice(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeSavingsPlanPriceRequest is the request struct for api DescribeSavingsPlanPrice
type DescribeSavingsPlanPriceRequest struct {
	*requests.RpcRequest
	InstanceTypeFamilyGroup string           `position:"Query" name:"InstanceTypeFamilyGroup"`
	Period                  requests.Integer `position:"Query" name:"Period"`
	ResourceId              *[]string        `position:"Query" name:"ResourceId"  type:"Repeated"`
	InstanceTypeFamily      string           `position:"Query" name:"InstanceTypeFamily"`
	PlanType                string           `position:"Query" name:"PlanType"`
	PeriodUnit              string           `position:"Query" name:"PeriodUnit"`
	OfferingType            string           `position:"Query" name:"OfferingType"`
	CommittedAmount         string           `position:"Query" name:"CommittedAmount"`
}

// DescribeSavingsPlanPriceResponse is the response struct for api DescribeSavingsPlanPrice
type DescribeSavingsPlanPriceResponse struct {
	*responses.BaseResponse
	RequestId string                              `json:"RequestId" xml:"RequestId"`
	PriceInfo PriceInfoInDescribeSavingsPlanPrice `json:"PriceInfo" xml:"PriceInfo"`
}

// CreateDescribeSavingsPlanPriceRequest creates a request to invoke DescribeSavingsPlanPrice API
func CreateDescribeSavingsPlanPriceRequest() (request *DescribeSavingsPlanPriceRequest) {
	request = &DescribeSavingsPlanPriceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ecs", "2014-05-26", "DescribeSavingsPlanPrice", "ecs", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeSavingsPlanPriceResponse creates a response to parse from DescribeSavingsPlanPrice response
func CreateDescribeSavingsPlanPriceResponse() (response *DescribeSavingsPlanPriceResponse) {
	response = &DescribeSavingsPlanPriceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
