package eais

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DetachEaisEi invokes the eais.DetachEaisEi API synchronously
func (client *Client) DetachEaisEi(request *DetachEaisEiRequest) (response *DetachEaisEiResponse, err error) {
	response = CreateDetachEaisEiResponse()
	err = client.DoAction(request, response)
	return
}

// DetachEaisEiWithChan invokes the eais.DetachEaisEi API asynchronously
func (client *Client) DetachEaisEiWithChan(request *DetachEaisEiRequest) (<-chan *DetachEaisEiResponse, <-chan error) {
	responseChan := make(chan *DetachEaisEiResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DetachEaisEi(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DetachEaisEiWithCallback invokes the eais.DetachEaisEi API asynchronously
func (client *Client) DetachEaisEiWithCallback(request *DetachEaisEiRequest, callback func(response *DetachEaisEiResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DetachEaisEiResponse
		var err error
		defer close(result)
		response, err = client.DetachEaisEi(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DetachEaisEiRequest is the request struct for api DetachEaisEi
type DetachEaisEiRequest struct {
	*requests.RpcRequest
	EiInstanceId string `position:"Query" name:"EiInstanceId"`
}

// DetachEaisEiResponse is the response struct for api DetachEaisEi
type DetachEaisEiResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDetachEaisEiRequest creates a request to invoke DetachEaisEi API
func CreateDetachEaisEiRequest() (request *DetachEaisEiRequest) {
	request = &DetachEaisEiRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("eais", "2019-06-24", "DetachEaisEi", "eais", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDetachEaisEiResponse creates a response to parse from DetachEaisEi response
func CreateDetachEaisEiResponse() (response *DetachEaisEiResponse) {
	response = &DetachEaisEiResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
