package dyvmsapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryRobotTaskList invokes the dyvmsapi.QueryRobotTaskList API synchronously
func (client *Client) QueryRobotTaskList(request *QueryRobotTaskListRequest) (response *QueryRobotTaskListResponse, err error) {
	response = CreateQueryRobotTaskListResponse()
	err = client.DoAction(request, response)
	return
}

// QueryRobotTaskListWithChan invokes the dyvmsapi.QueryRobotTaskList API asynchronously
func (client *Client) QueryRobotTaskListWithChan(request *QueryRobotTaskListRequest) (<-chan *QueryRobotTaskListResponse, <-chan error) {
	responseChan := make(chan *QueryRobotTaskListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryRobotTaskList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryRobotTaskListWithCallback invokes the dyvmsapi.QueryRobotTaskList API asynchronously
func (client *Client) QueryRobotTaskListWithCallback(request *QueryRobotTaskListRequest, callback func(response *QueryRobotTaskListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryRobotTaskListResponse
		var err error
		defer close(result)
		response, err = client.QueryRobotTaskList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryRobotTaskListRequest is the request struct for api QueryRobotTaskList
type QueryRobotTaskListRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	TaskName             string           `position:"Query" name:"TaskName"`
	PageSize             requests.Integer `position:"Query" name:"PageSize"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	PageNo               requests.Integer `position:"Query" name:"PageNo"`
	Time                 string           `position:"Query" name:"Time"`
	Status               string           `position:"Query" name:"Status"`
}

// QueryRobotTaskListResponse is the response struct for api QueryRobotTaskList
type QueryRobotTaskListResponse struct {
	*responses.BaseResponse
	RequestId  string `json:"RequestId" xml:"RequestId"`
	Data       string `json:"Data" xml:"Data"`
	PageSize   string `json:"PageSize" xml:"PageSize"`
	PageNo     string `json:"PageNo" xml:"PageNo"`
	TotalCount string `json:"TotalCount" xml:"TotalCount"`
	Code       string `json:"Code" xml:"Code"`
	Message    string `json:"Message" xml:"Message"`
}

// CreateQueryRobotTaskListRequest creates a request to invoke QueryRobotTaskList API
func CreateQueryRobotTaskListRequest() (request *QueryRobotTaskListRequest) {
	request = &QueryRobotTaskListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Dyvmsapi", "2017-05-25", "QueryRobotTaskList", "dyvms", "openAPI")
	request.Method = requests.POST
	return
}

// CreateQueryRobotTaskListResponse creates a response to parse from QueryRobotTaskList response
func CreateQueryRobotTaskListResponse() (response *QueryRobotTaskListResponse) {
	response = &QueryRobotTaskListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
