package domain

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SaveSingleTaskForReserveDropListDomain invokes the domain.SaveSingleTaskForReserveDropListDomain API synchronously
func (client *Client) SaveSingleTaskForReserveDropListDomain(request *SaveSingleTaskForReserveDropListDomainRequest) (response *SaveSingleTaskForReserveDropListDomainResponse, err error) {
	response = CreateSaveSingleTaskForReserveDropListDomainResponse()
	err = client.DoAction(request, response)
	return
}

// SaveSingleTaskForReserveDropListDomainWithChan invokes the domain.SaveSingleTaskForReserveDropListDomain API asynchronously
func (client *Client) SaveSingleTaskForReserveDropListDomainWithChan(request *SaveSingleTaskForReserveDropListDomainRequest) (<-chan *SaveSingleTaskForReserveDropListDomainResponse, <-chan error) {
	responseChan := make(chan *SaveSingleTaskForReserveDropListDomainResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SaveSingleTaskForReserveDropListDomain(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SaveSingleTaskForReserveDropListDomainWithCallback invokes the domain.SaveSingleTaskForReserveDropListDomain API asynchronously
func (client *Client) SaveSingleTaskForReserveDropListDomainWithCallback(request *SaveSingleTaskForReserveDropListDomainRequest, callback func(response *SaveSingleTaskForReserveDropListDomainResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SaveSingleTaskForReserveDropListDomainResponse
		var err error
		defer close(result)
		response, err = client.SaveSingleTaskForReserveDropListDomain(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SaveSingleTaskForReserveDropListDomainRequest is the request struct for api SaveSingleTaskForReserveDropListDomain
type SaveSingleTaskForReserveDropListDomainRequest struct {
	*requests.RpcRequest
	Dns2              string `position:"Query" name:"Dns2"`
	Dns1              string `position:"Query" name:"Dns1"`
	DomainName        string `position:"Query" name:"DomainName"`
	ContactTemplateId string `position:"Query" name:"ContactTemplateId"`
}

// SaveSingleTaskForReserveDropListDomainResponse is the response struct for api SaveSingleTaskForReserveDropListDomain
type SaveSingleTaskForReserveDropListDomainResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	TaskNo    string `json:"TaskNo" xml:"TaskNo"`
}

// CreateSaveSingleTaskForReserveDropListDomainRequest creates a request to invoke SaveSingleTaskForReserveDropListDomain API
func CreateSaveSingleTaskForReserveDropListDomainRequest() (request *SaveSingleTaskForReserveDropListDomainRequest) {
	request = &SaveSingleTaskForReserveDropListDomainRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Domain", "2018-01-29", "SaveSingleTaskForReserveDropListDomain", "domain", "openAPI")
	request.Method = requests.POST
	return
}

// CreateSaveSingleTaskForReserveDropListDomainResponse creates a response to parse from SaveSingleTaskForReserveDropListDomain response
func CreateSaveSingleTaskForReserveDropListDomainResponse() (response *SaveSingleTaskForReserveDropListDomainResponse) {
	response = &SaveSingleTaskForReserveDropListDomainResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
