package dms_enterprise

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateScenario invokes the dms_enterprise.CreateScenario API synchronously
func (client *Client) CreateScenario(request *CreateScenarioRequest) (response *CreateScenarioResponse, err error) {
	response = CreateCreateScenarioResponse()
	err = client.DoAction(request, response)
	return
}

// CreateScenarioWithChan invokes the dms_enterprise.CreateScenario API asynchronously
func (client *Client) CreateScenarioWithChan(request *CreateScenarioRequest) (<-chan *CreateScenarioResponse, <-chan error) {
	responseChan := make(chan *CreateScenarioResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateScenario(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateScenarioWithCallback invokes the dms_enterprise.CreateScenario API asynchronously
func (client *Client) CreateScenarioWithCallback(request *CreateScenarioRequest, callback func(response *CreateScenarioResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateScenarioResponse
		var err error
		defer close(result)
		response, err = client.CreateScenario(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateScenarioRequest is the request struct for api CreateScenario
type CreateScenarioRequest struct {
	*requests.RpcRequest
	Description  string           `position:"Query" name:"Description"`
	Tid          requests.Integer `position:"Query" name:"Tid"`
	ScenarioName string           `position:"Query" name:"ScenarioName"`
}

// CreateScenarioResponse is the response struct for api CreateScenario
type CreateScenarioResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	ErrorCode    string `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	Success      bool   `json:"Success" xml:"Success"`
	ScenarioId   int64  `json:"ScenarioId" xml:"ScenarioId"`
}

// CreateCreateScenarioRequest creates a request to invoke CreateScenario API
func CreateCreateScenarioRequest() (request *CreateScenarioRequest) {
	request = &CreateScenarioRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dms-enterprise", "2018-11-01", "CreateScenario", "dms-enterprise", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateScenarioResponse creates a response to parse from CreateScenario response
func CreateCreateScenarioResponse() (response *CreateScenarioResponse) {
	response = &CreateScenarioResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
