package dds

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDBInstancesOverview invokes the dds.DescribeDBInstancesOverview API synchronously
func (client *Client) DescribeDBInstancesOverview(request *DescribeDBInstancesOverviewRequest) (response *DescribeDBInstancesOverviewResponse, err error) {
	response = CreateDescribeDBInstancesOverviewResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDBInstancesOverviewWithChan invokes the dds.DescribeDBInstancesOverview API asynchronously
func (client *Client) DescribeDBInstancesOverviewWithChan(request *DescribeDBInstancesOverviewRequest) (<-chan *DescribeDBInstancesOverviewResponse, <-chan error) {
	responseChan := make(chan *DescribeDBInstancesOverviewResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDBInstancesOverview(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDBInstancesOverviewWithCallback invokes the dds.DescribeDBInstancesOverview API asynchronously
func (client *Client) DescribeDBInstancesOverviewWithCallback(request *DescribeDBInstancesOverviewRequest, callback func(response *DescribeDBInstancesOverviewResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDBInstancesOverviewResponse
		var err error
		defer close(result)
		response, err = client.DescribeDBInstancesOverview(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDBInstancesOverviewRequest is the request struct for api DescribeDBInstancesOverview
type DescribeDBInstancesOverviewRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	NetworkType          string           `position:"Query" name:"NetworkType"`
	EngineVersion        string           `position:"Query" name:"EngineVersion"`
	InstanceClass        string           `position:"Query" name:"InstanceClass"`
	ResourceGroupId      string           `position:"Query" name:"ResourceGroupId"`
	InstanceType         string           `position:"Query" name:"InstanceType"`
	InstanceStatus       string           `position:"Query" name:"InstanceStatus"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	VSwitchId            string           `position:"Query" name:"VSwitchId"`
	InstanceIds          string           `position:"Query" name:"InstanceIds"`
	VpcId                string           `position:"Query" name:"VpcId"`
	ZoneId               string           `position:"Query" name:"ZoneId"`
	ChargeType           string           `position:"Query" name:"ChargeType"`
}

// DescribeDBInstancesOverviewResponse is the response struct for api DescribeDBInstancesOverview
type DescribeDBInstancesOverviewResponse struct {
	*responses.BaseResponse
	TotalCount  string                                    `json:"TotalCount" xml:"TotalCount"`
	RequestId   string                                    `json:"RequestId" xml:"RequestId"`
	DBInstances []DBInstanceInDescribeDBInstancesOverview `json:"DBInstances" xml:"DBInstances"`
}

// CreateDescribeDBInstancesOverviewRequest creates a request to invoke DescribeDBInstancesOverview API
func CreateDescribeDBInstancesOverviewRequest() (request *DescribeDBInstancesOverviewRequest) {
	request = &DescribeDBInstancesOverviewRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Dds", "2015-12-01", "DescribeDBInstancesOverview", "dds", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeDBInstancesOverviewResponse creates a response to parse from DescribeDBInstancesOverview response
func CreateDescribeDBInstancesOverviewResponse() (response *DescribeDBInstancesOverviewResponse) {
	response = &DescribeDBInstancesOverviewResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
