package cusanalytic_sc_online

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetActionCursor invokes the cusanalytic_sc_online.GetActionCursor API synchronously
// api document: https://help.aliyun.com/api/cusanalytic_sc_online/getactioncursor.html
func (client *Client) GetActionCursor(request *GetActionCursorRequest) (response *GetActionCursorResponse, err error) {
	response = CreateGetActionCursorResponse()
	err = client.DoAction(request, response)
	return
}

// GetActionCursorWithChan invokes the cusanalytic_sc_online.GetActionCursor API asynchronously
// api document: https://help.aliyun.com/api/cusanalytic_sc_online/getactioncursor.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetActionCursorWithChan(request *GetActionCursorRequest) (<-chan *GetActionCursorResponse, <-chan error) {
	responseChan := make(chan *GetActionCursorResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetActionCursor(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetActionCursorWithCallback invokes the cusanalytic_sc_online.GetActionCursor API asynchronously
// api document: https://help.aliyun.com/api/cusanalytic_sc_online/getactioncursor.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetActionCursorWithCallback(request *GetActionCursorRequest, callback func(response *GetActionCursorResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetActionCursorResponse
		var err error
		defer close(result)
		response, err = client.GetActionCursor(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetActionCursorRequest is the request struct for api GetActionCursor
type GetActionCursorRequest struct {
	*requests.RpcRequest
	StoreId string `position:"Body" name:"StoreId"`
}

// GetActionCursorResponse is the response struct for api GetActionCursor
type GetActionCursorResponse struct {
	*responses.BaseResponse
	ErrorMsg  string `json:"ErrorMsg" xml:"ErrorMsg"`
	Timestamp int64  `json:"Timestamp" xml:"Timestamp"`
	Success   bool   `json:"Success" xml:"Success"`
}

// CreateGetActionCursorRequest creates a request to invoke GetActionCursor API
func CreateGetActionCursorRequest() (request *GetActionCursorRequest) {
	request = &GetActionCursorRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cusanalytic_sc_online", "2019-05-24", "GetActionCursor", "", "")
	return
}

// CreateGetActionCursorResponse creates a response to parse from GetActionCursor response
func CreateGetActionCursorResponse() (response *GetActionCursorResponse) {
	response = &GetActionCursorResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
