package csas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateIdpDepartment invokes the csas.UpdateIdpDepartment API synchronously
func (client *Client) UpdateIdpDepartment(request *UpdateIdpDepartmentRequest) (response *UpdateIdpDepartmentResponse, err error) {
	response = CreateUpdateIdpDepartmentResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateIdpDepartmentWithChan invokes the csas.UpdateIdpDepartment API asynchronously
func (client *Client) UpdateIdpDepartmentWithChan(request *UpdateIdpDepartmentRequest) (<-chan *UpdateIdpDepartmentResponse, <-chan error) {
	responseChan := make(chan *UpdateIdpDepartmentResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateIdpDepartment(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateIdpDepartmentWithCallback invokes the csas.UpdateIdpDepartment API asynchronously
func (client *Client) UpdateIdpDepartmentWithCallback(request *UpdateIdpDepartmentRequest, callback func(response *UpdateIdpDepartmentResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateIdpDepartmentResponse
		var err error
		defer close(result)
		response, err = client.UpdateIdpDepartment(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateIdpDepartmentRequest is the request struct for api UpdateIdpDepartment
type UpdateIdpDepartmentRequest struct {
	*requests.RpcRequest
	DepartmentId   string `position:"Query" name:"DepartmentId"`
	IdpConfigId    string `position:"Query" name:"IdpConfigId"`
	DepartmentName string `position:"Query" name:"DepartmentName"`
}

// UpdateIdpDepartmentResponse is the response struct for api UpdateIdpDepartment
type UpdateIdpDepartmentResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateUpdateIdpDepartmentRequest creates a request to invoke UpdateIdpDepartment API
func CreateUpdateIdpDepartmentRequest() (request *UpdateIdpDepartmentRequest) {
	request = &UpdateIdpDepartmentRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("csas", "2023-01-20", "UpdateIdpDepartment", "", "")
	request.Method = requests.POST
	return
}

// CreateUpdateIdpDepartmentResponse creates a response to parse from UpdateIdpDepartment response
func CreateUpdateIdpDepartmentResponse() (response *UpdateIdpDepartmentResponse) {
	response = &UpdateIdpDepartmentResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
