package csas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateClientUserPassword invokes the csas.UpdateClientUserPassword API synchronously
func (client *Client) UpdateClientUserPassword(request *UpdateClientUserPasswordRequest) (response *UpdateClientUserPasswordResponse, err error) {
	response = CreateUpdateClientUserPasswordResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateClientUserPasswordWithChan invokes the csas.UpdateClientUserPassword API asynchronously
func (client *Client) UpdateClientUserPasswordWithChan(request *UpdateClientUserPasswordRequest) (<-chan *UpdateClientUserPasswordResponse, <-chan error) {
	responseChan := make(chan *UpdateClientUserPasswordResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateClientUserPassword(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateClientUserPasswordWithCallback invokes the csas.UpdateClientUserPassword API asynchronously
func (client *Client) UpdateClientUserPasswordWithCallback(request *UpdateClientUserPasswordRequest, callback func(response *UpdateClientUserPasswordResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateClientUserPasswordResponse
		var err error
		defer close(result)
		response, err = client.UpdateClientUserPassword(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateClientUserPasswordRequest is the request struct for api UpdateClientUserPassword
type UpdateClientUserPasswordRequest struct {
	*requests.RpcRequest
	Password string `position:"Query" name:"Password"`
	Id       string `position:"Query" name:"Id"`
	Username string `position:"Query" name:"Username"`
}

// UpdateClientUserPasswordResponse is the response struct for api UpdateClientUserPassword
type UpdateClientUserPasswordResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateUpdateClientUserPasswordRequest creates a request to invoke UpdateClientUserPassword API
func CreateUpdateClientUserPasswordRequest() (request *UpdateClientUserPasswordRequest) {
	request = &UpdateClientUserPasswordRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("csas", "2023-01-20", "UpdateClientUserPassword", "", "")
	request.Method = requests.POST
	return
}

// CreateUpdateClientUserPasswordResponse creates a response to parse from UpdateClientUserPassword response
func CreateUpdateClientUserPasswordResponse() (response *UpdateClientUserPasswordResponse) {
	response = &UpdateClientUserPasswordResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
