package cloud_siem

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListAutomateResponseConfigs invokes the cloud_siem.ListAutomateResponseConfigs API synchronously
func (client *Client) ListAutomateResponseConfigs(request *ListAutomateResponseConfigsRequest) (response *ListAutomateResponseConfigsResponse, err error) {
	response = CreateListAutomateResponseConfigsResponse()
	err = client.DoAction(request, response)
	return
}

// ListAutomateResponseConfigsWithChan invokes the cloud_siem.ListAutomateResponseConfigs API asynchronously
func (client *Client) ListAutomateResponseConfigsWithChan(request *ListAutomateResponseConfigsRequest) (<-chan *ListAutomateResponseConfigsResponse, <-chan error) {
	responseChan := make(chan *ListAutomateResponseConfigsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListAutomateResponseConfigs(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListAutomateResponseConfigsWithCallback invokes the cloud_siem.ListAutomateResponseConfigs API asynchronously
func (client *Client) ListAutomateResponseConfigsWithCallback(request *ListAutomateResponseConfigsRequest, callback func(response *ListAutomateResponseConfigsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListAutomateResponseConfigsResponse
		var err error
		defer close(result)
		response, err = client.ListAutomateResponseConfigs(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListAutomateResponseConfigsRequest is the request struct for api ListAutomateResponseConfigs
type ListAutomateResponseConfigsRequest struct {
	*requests.RpcRequest
	ActionType       string           `position:"Body" name:"ActionType"`
	RuleName         string           `position:"Body" name:"RuleName"`
	SubUserId        requests.Integer `position:"Body" name:"SubUserId"`
	PageSize         requests.Integer `position:"Body" name:"PageSize"`
	AutoResponseType string           `position:"Body" name:"AutoResponseType"`
	Id               requests.Integer `position:"Body" name:"Id"`
	CurrentPage      requests.Integer `position:"Body" name:"CurrentPage"`
	PlaybookUuid     string           `position:"Body" name:"PlaybookUuid"`
	Status           requests.Integer `position:"Body" name:"Status"`
}

// ListAutomateResponseConfigsResponse is the response struct for api ListAutomateResponseConfigs
type ListAutomateResponseConfigsResponse struct {
	*responses.BaseResponse
	Success   bool   `json:"Success" xml:"Success"`
	Code      int    `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateListAutomateResponseConfigsRequest creates a request to invoke ListAutomateResponseConfigs API
func CreateListAutomateResponseConfigsRequest() (request *ListAutomateResponseConfigsRequest) {
	request = &ListAutomateResponseConfigsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloud-siem", "2022-06-16", "ListAutomateResponseConfigs", "cloud-siem", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListAutomateResponseConfigsResponse creates a response to parse from ListAutomateResponseConfigs response
func CreateListAutomateResponseConfigsResponse() (response *ListAutomateResponseConfigsResponse) {
	response = &ListAutomateResponseConfigsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
