package cdn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeFCTrigger invokes the cdn.DescribeFCTrigger API synchronously
func (client *Client) DescribeFCTrigger(request *DescribeFCTriggerRequest) (response *DescribeFCTriggerResponse, err error) {
	response = CreateDescribeFCTriggerResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeFCTriggerWithChan invokes the cdn.DescribeFCTrigger API asynchronously
func (client *Client) DescribeFCTriggerWithChan(request *DescribeFCTriggerRequest) (<-chan *DescribeFCTriggerResponse, <-chan error) {
	responseChan := make(chan *DescribeFCTriggerResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeFCTrigger(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeFCTriggerWithCallback invokes the cdn.DescribeFCTrigger API asynchronously
func (client *Client) DescribeFCTriggerWithCallback(request *DescribeFCTriggerRequest, callback func(response *DescribeFCTriggerResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeFCTriggerResponse
		var err error
		defer close(result)
		response, err = client.DescribeFCTrigger(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeFCTriggerRequest is the request struct for api DescribeFCTrigger
type DescribeFCTriggerRequest struct {
	*requests.RpcRequest
	TriggerARN string `position:"Query" name:"TriggerARN"`
}

// DescribeFCTriggerResponse is the response struct for api DescribeFCTrigger
type DescribeFCTriggerResponse struct {
	*responses.BaseResponse
	RequestId string    `json:"RequestId" xml:"RequestId"`
	FCTrigger FCTrigger `json:"FCTrigger" xml:"FCTrigger"`
}

// CreateDescribeFCTriggerRequest creates a request to invoke DescribeFCTrigger API
func CreateDescribeFCTriggerRequest() (request *DescribeFCTriggerRequest) {
	request = &DescribeFCTriggerRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cdn", "2018-05-10", "DescribeFCTrigger", "", "")
	request.Method = requests.GET
	return
}

// CreateDescribeFCTriggerResponse creates a response to parse from DescribeFCTrigger response
func CreateDescribeFCTriggerResponse() (response *DescribeFCTriggerResponse) {
	response = &DescribeFCTriggerResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
