package cc5g

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AttachVpcToNetLink invokes the cc5g.AttachVpcToNetLink API synchronously
func (client *Client) AttachVpcToNetLink(request *AttachVpcToNetLinkRequest) (response *AttachVpcToNetLinkResponse, err error) {
	response = CreateAttachVpcToNetLinkResponse()
	err = client.DoAction(request, response)
	return
}

// AttachVpcToNetLinkWithChan invokes the cc5g.AttachVpcToNetLink API asynchronously
func (client *Client) AttachVpcToNetLinkWithChan(request *AttachVpcToNetLinkRequest) (<-chan *AttachVpcToNetLinkResponse, <-chan error) {
	responseChan := make(chan *AttachVpcToNetLinkResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AttachVpcToNetLink(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AttachVpcToNetLinkWithCallback invokes the cc5g.AttachVpcToNetLink API asynchronously
func (client *Client) AttachVpcToNetLinkWithCallback(request *AttachVpcToNetLinkRequest, callback func(response *AttachVpcToNetLinkResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AttachVpcToNetLinkResponse
		var err error
		defer close(result)
		response, err = client.AttachVpcToNetLink(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AttachVpcToNetLinkRequest is the request struct for api AttachVpcToNetLink
type AttachVpcToNetLinkRequest struct {
	*requests.RpcRequest
	ClientToken              string           `position:"Query" name:"ClientToken"`
	DryRun                   requests.Boolean `position:"Query" name:"DryRun"`
	NetLinkId                string           `position:"Query" name:"NetLinkId"`
	VSwitches                *[]string        `position:"Query" name:"VSwitches"  type:"Repeated"`
	WirelessCloudConnectorId string           `position:"Query" name:"WirelessCloudConnectorId"`
	VpcId                    string           `position:"Query" name:"VpcId"`
}

// AttachVpcToNetLinkResponse is the response struct for api AttachVpcToNetLink
type AttachVpcToNetLinkResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateAttachVpcToNetLinkRequest creates a request to invoke AttachVpcToNetLink API
func CreateAttachVpcToNetLinkRequest() (request *AttachVpcToNetLinkRequest) {
	request = &AttachVpcToNetLinkRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CC5G", "2022-03-14", "AttachVpcToNetLink", "fivegcc", "openAPI")
	request.Method = requests.POST
	return
}

// CreateAttachVpcToNetLinkResponse creates a response to parse from AttachVpcToNetLink response
func CreateAttachVpcToNetLinkResponse() (response *AttachVpcToNetLinkResponse) {
	response = &AttachVpcToNetLinkResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
