package beian

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryAccessorDomainStatus invokes the beian.QueryAccessorDomainStatus API synchronously
func (client *Client) QueryAccessorDomainStatus(request *QueryAccessorDomainStatusRequest) (response *QueryAccessorDomainStatusResponse, err error) {
	response = CreateQueryAccessorDomainStatusResponse()
	err = client.DoAction(request, response)
	return
}

// QueryAccessorDomainStatusWithChan invokes the beian.QueryAccessorDomainStatus API asynchronously
func (client *Client) QueryAccessorDomainStatusWithChan(request *QueryAccessorDomainStatusRequest) (<-chan *QueryAccessorDomainStatusResponse, <-chan error) {
	responseChan := make(chan *QueryAccessorDomainStatusResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryAccessorDomainStatus(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryAccessorDomainStatusWithCallback invokes the beian.QueryAccessorDomainStatus API asynchronously
func (client *Client) QueryAccessorDomainStatusWithCallback(request *QueryAccessorDomainStatusRequest, callback func(response *QueryAccessorDomainStatusResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryAccessorDomainStatusResponse
		var err error
		defer close(result)
		response, err = client.QueryAccessorDomainStatus(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryAccessorDomainStatusRequest is the request struct for api QueryAccessorDomainStatus
type QueryAccessorDomainStatusRequest struct {
	*requests.RpcRequest
	Caller string `position:"Query" name:"Caller"`
	Domain string `position:"Query" name:"Domain"`
}

// QueryAccessorDomainStatusResponse is the response struct for api QueryAccessorDomainStatus
type QueryAccessorDomainStatusResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      int    `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateQueryAccessorDomainStatusRequest creates a request to invoke QueryAccessorDomainStatus API
func CreateQueryAccessorDomainStatusRequest() (request *QueryAccessorDomainStatusRequest) {
	request = &QueryAccessorDomainStatusRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Beian", "2016-08-10", "QueryAccessorDomainStatus", "", "")
	request.Method = requests.POST
	return
}

// CreateQueryAccessorDomainStatusResponse creates a response to parse from QueryAccessorDomainStatus response
func CreateQueryAccessorDomainStatusResponse() (response *QueryAccessorDomainStatusResponse) {
	response = &QueryAccessorDomainStatusResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
