package arms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteWebhookContact invokes the arms.DeleteWebhookContact API synchronously
func (client *Client) DeleteWebhookContact(request *DeleteWebhookContactRequest) (response *DeleteWebhookContactResponse, err error) {
	response = CreateDeleteWebhookContactResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteWebhookContactWithChan invokes the arms.DeleteWebhookContact API asynchronously
func (client *Client) DeleteWebhookContactWithChan(request *DeleteWebhookContactRequest) (<-chan *DeleteWebhookContactResponse, <-chan error) {
	responseChan := make(chan *DeleteWebhookContactResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteWebhookContact(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteWebhookContactWithCallback invokes the arms.DeleteWebhookContact API asynchronously
func (client *Client) DeleteWebhookContactWithCallback(request *DeleteWebhookContactRequest, callback func(response *DeleteWebhookContactResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteWebhookContactResponse
		var err error
		defer close(result)
		response, err = client.DeleteWebhookContact(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteWebhookContactRequest is the request struct for api DeleteWebhookContact
type DeleteWebhookContactRequest struct {
	*requests.RpcRequest
	WebhookId requests.Integer `position:"Query" name:"WebhookId"`
}

// DeleteWebhookContactResponse is the response struct for api DeleteWebhookContact
type DeleteWebhookContactResponse struct {
	*responses.BaseResponse
	RequestId                     string `json:"RequestId" xml:"RequestId"`
	DeleteWebhookContactIsSuccess bool   `json:"IsSuccess" xml:"IsSuccess"`
}

// CreateDeleteWebhookContactRequest creates a request to invoke DeleteWebhookContact API
func CreateDeleteWebhookContactRequest() (request *DeleteWebhookContactRequest) {
	request = &DeleteWebhookContactRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ARMS", "2019-08-08", "DeleteWebhookContact", "arms", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteWebhookContactResponse creates a response to parse from DeleteWebhookContact response
func CreateDeleteWebhookContactResponse() (response *DeleteWebhookContactResponse) {
	response = &DeleteWebhookContactResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
