package appstream_center

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// PageListAppInstanceGroupUser invokes the appstream_center.PageListAppInstanceGroupUser API synchronously
func (client *Client) PageListAppInstanceGroupUser(request *PageListAppInstanceGroupUserRequest) (response *PageListAppInstanceGroupUserResponse, err error) {
	response = CreatePageListAppInstanceGroupUserResponse()
	err = client.DoAction(request, response)
	return
}

// PageListAppInstanceGroupUserWithChan invokes the appstream_center.PageListAppInstanceGroupUser API asynchronously
func (client *Client) PageListAppInstanceGroupUserWithChan(request *PageListAppInstanceGroupUserRequest) (<-chan *PageListAppInstanceGroupUserResponse, <-chan error) {
	responseChan := make(chan *PageListAppInstanceGroupUserResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.PageListAppInstanceGroupUser(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// PageListAppInstanceGroupUserWithCallback invokes the appstream_center.PageListAppInstanceGroupUser API asynchronously
func (client *Client) PageListAppInstanceGroupUserWithCallback(request *PageListAppInstanceGroupUserRequest, callback func(response *PageListAppInstanceGroupUserResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *PageListAppInstanceGroupUserResponse
		var err error
		defer close(result)
		response, err = client.PageListAppInstanceGroupUser(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// PageListAppInstanceGroupUserRequest is the request struct for api PageListAppInstanceGroupUser
type PageListAppInstanceGroupUserRequest struct {
	*requests.RpcRequest
	PageNumber         requests.Integer `position:"Body" name:"PageNumber"`
	ProductType        string           `position:"Body" name:"ProductType"`
	AppInstanceGroupId string           `position:"Body" name:"AppInstanceGroupId"`
	PageSize           requests.Integer `position:"Body" name:"PageSize"`
}

// PageListAppInstanceGroupUserResponse is the response struct for api PageListAppInstanceGroupUser
type PageListAppInstanceGroupUserResponse struct {
	*responses.BaseResponse
	RequestId string   `json:"RequestId" xml:"RequestId"`
	Users     []string `json:"Users" xml:"Users"`
}

// CreatePageListAppInstanceGroupUserRequest creates a request to invoke PageListAppInstanceGroupUser API
func CreatePageListAppInstanceGroupUserRequest() (request *PageListAppInstanceGroupUserRequest) {
	request = &PageListAppInstanceGroupUserRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("appstream-center", "2021-09-01", "PageListAppInstanceGroupUser", "", "")
	request.Method = requests.POST
	return
}

// CreatePageListAppInstanceGroupUserResponse creates a response to parse from PageListAppInstanceGroupUser response
func CreatePageListAppInstanceGroupUserResponse() (response *PageListAppInstanceGroupUserResponse) {
	response = &PageListAppInstanceGroupUserResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
