package ahas_openapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetMetricsOfResource invokes the ahas_openapi.GetMetricsOfResource API synchronously
func (client *Client) GetMetricsOfResource(request *GetMetricsOfResourceRequest) (response *GetMetricsOfResourceResponse, err error) {
	response = CreateGetMetricsOfResourceResponse()
	err = client.DoAction(request, response)
	return
}

// GetMetricsOfResourceWithChan invokes the ahas_openapi.GetMetricsOfResource API asynchronously
func (client *Client) GetMetricsOfResourceWithChan(request *GetMetricsOfResourceRequest) (<-chan *GetMetricsOfResourceResponse, <-chan error) {
	responseChan := make(chan *GetMetricsOfResourceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetMetricsOfResource(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetMetricsOfResourceWithCallback invokes the ahas_openapi.GetMetricsOfResource API asynchronously
func (client *Client) GetMetricsOfResourceWithCallback(request *GetMetricsOfResourceRequest, callback func(response *GetMetricsOfResourceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetMetricsOfResourceResponse
		var err error
		defer close(result)
		response, err = client.GetMetricsOfResource(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetMetricsOfResourceRequest is the request struct for api GetMetricsOfResource
type GetMetricsOfResourceRequest struct {
	*requests.RpcRequest
	Resource     string           `position:"Query" name:"Resource"`
	EndTime      requests.Integer `position:"Query" name:"EndTime"`
	StartTime    requests.Integer `position:"Query" name:"StartTime"`
	AhasRegionId string           `position:"Query" name:"AhasRegionId"`
	AppName      string           `position:"Query" name:"AppName"`
	Namespace    string           `position:"Query" name:"Namespace"`
}

// GetMetricsOfResourceResponse is the response struct for api GetMetricsOfResource
type GetMetricsOfResourceResponse struct {
	*responses.BaseResponse
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      string `json:"Code" xml:"Code"`
	Success   bool   `json:"Success" xml:"Success"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateGetMetricsOfResourceRequest creates a request to invoke GetMetricsOfResource API
func CreateGetMetricsOfResourceRequest() (request *GetMetricsOfResourceRequest) {
	request = &GetMetricsOfResourceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ahas-openapi", "2019-09-01", "GetMetricsOfResource", "ahas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetMetricsOfResourceResponse creates a response to parse from GetMetricsOfResource response
func CreateGetMetricsOfResourceResponse() (response *GetMetricsOfResourceResponse) {
	response = &GetMetricsOfResourceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
