package adb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeLoadTasksRecords invokes the adb.DescribeLoadTasksRecords API synchronously
func (client *Client) DescribeLoadTasksRecords(request *DescribeLoadTasksRecordsRequest) (response *DescribeLoadTasksRecordsResponse, err error) {
	response = CreateDescribeLoadTasksRecordsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeLoadTasksRecordsWithChan invokes the adb.DescribeLoadTasksRecords API asynchronously
func (client *Client) DescribeLoadTasksRecordsWithChan(request *DescribeLoadTasksRecordsRequest) (<-chan *DescribeLoadTasksRecordsResponse, <-chan error) {
	responseChan := make(chan *DescribeLoadTasksRecordsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeLoadTasksRecords(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeLoadTasksRecordsWithCallback invokes the adb.DescribeLoadTasksRecords API asynchronously
func (client *Client) DescribeLoadTasksRecordsWithCallback(request *DescribeLoadTasksRecordsRequest, callback func(response *DescribeLoadTasksRecordsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeLoadTasksRecordsResponse
		var err error
		defer close(result)
		response, err = client.DescribeLoadTasksRecords(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeLoadTasksRecordsRequest is the request struct for api DescribeLoadTasksRecords
type DescribeLoadTasksRecordsRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	Range                string           `position:"Query" name:"Range"`
	StartTime            string           `position:"Query" name:"StartTime"`
	PageNumber           requests.Integer `position:"Query" name:"PageNumber"`
	PageSize             requests.Integer `position:"Query" name:"PageSize"`
	State                string           `position:"Query" name:"State"`
	Order                string           `position:"Query" name:"Order"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	DBClusterId          string           `position:"Query" name:"DBClusterId"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	EndTime              string           `position:"Query" name:"EndTime"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	DBName               string           `position:"Query" name:"DBName"`
}

// DescribeLoadTasksRecordsResponse is the response struct for api DescribeLoadTasksRecords
type DescribeLoadTasksRecordsResponse struct {
	*responses.BaseResponse
	TotalCount       string           `json:"TotalCount" xml:"TotalCount"`
	PageSize         string           `json:"PageSize" xml:"PageSize"`
	RequestId        string           `json:"RequestId" xml:"RequestId"`
	PageNumber       string           `json:"PageNumber" xml:"PageNumber"`
	DBClusterId      string           `json:"DBClusterId" xml:"DBClusterId"`
	LoadTasksRecords []LoadTaskRecord `json:"LoadTasksRecords" xml:"LoadTasksRecords"`
}

// CreateDescribeLoadTasksRecordsRequest creates a request to invoke DescribeLoadTasksRecords API
func CreateDescribeLoadTasksRecordsRequest() (request *DescribeLoadTasksRecordsRequest) {
	request = &DescribeLoadTasksRecordsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("adb", "2019-03-15", "DescribeLoadTasksRecords", "ads", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeLoadTasksRecordsResponse creates a response to parse from DescribeLoadTasksRecords response
func CreateDescribeLoadTasksRecordsResponse() (response *DescribeLoadTasksRecordsResponse) {
	response = &DescribeLoadTasksRecordsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
