# 🚧 Thank you for opening a PR!

A few important guidelines and requirements before we can merge your PR:

- [ ] We should be able to understand what the PR does from its title only;
- [ ] There is a high-level description of the changes;
- [ ] *If I add a new feature*, there is an [issue][issues] discussing it already;
- [ ] There are links to *all* the relevant issues, discussions and PRs;
- [ ] The branch is rebased on the latest `main` commit;
- [ ] **Commit messages** follow these [guidelines][git-guidelines];
- [ ] One commit per logical change;
- [ ] The code respects the current **naming conventions**;
- [ ] Docstrings follow the [numpy style guide][docstring-guidelines];
- [ ] `pre-commit` is installed and configured on your machine, and you ran it before opening the PR;
- [ ] There are tests covering the changes;
- [ ] The documentation is up-to-date;

Consider opening a **Draft PR** if your work is still in progress but you would
like some feedback from other contributors.

[issues]: https://github.com/dottxt-ai/outlines/issues
[git-guidelines]: https://tbaggery.com/2008/04/19/a-note-about-git-commit-messages.html
[docstring-guidelines]: https://numpydoc.readthedocs.io/en/latest/format.html
